package com.maniu.douyinsample;

import android.content.Context;
import android.media.AudioFormat;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.media.MediaPlayer;
import android.os.Environment;
import android.util.Log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class VideoEditor {

    public static void mixAudioTrack(Context context,
                                     final String videoInput,
                                     final String audioInput,
                                     final String output,
                                     final Integer startTimeUs, final Integer endTimeUs,
                                     int videoVolume,//0 -100
                                     int aacVolume//0-100
    ) throws  Exception {

        File cacheDir = new File(Environment.getExternalStorageDirectory(), "movie");
//        下载下来的音乐转换城pcm
        File aacPcmFile = new File(cacheDir, "audio"  + ".pcm");

        //        视频自带的音乐转换城pcm
        final File videoPcmFile = new File(cacheDir, "video"  + ".pcm");
//        融合之后的音频pcm文件
        File  adjustedPcm = new File(cacheDir, "混合后的"  + ".pcm");


//            音乐时间   读取视频时间  读取视频 音频  的配置
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();

        mediaMetadataRetriever.setDataSource(audioInput);
//        读取音乐时间
        final int aacDurationMs = Integer.parseInt(mediaMetadataRetriever.
                extractMetadata(MediaMetadataRetriever.METADATA_KEY_DURATION));

        mediaMetadataRetriever.release();

//       剪辑后的视频时长
        final int videoDurationMs = (endTimeUs - startTimeUs);

//        mp3----->pcm  剪辑
        decodeToPCM(videoInput, videoPcmFile.getAbsolutePath(), startTimeUs, videoDurationMs);
        decodeToPCM(audioInput, aacPcmFile.getAbsolutePath(), 30, 30+videoDurationMs);
        mixPcm(videoPcmFile.getAbsolutePath(), aacPcmFile.getAbsolutePath(), adjustedPcm.getAbsolutePath()
                , videoVolume, aacVolume);
        File wavFile = new File(cacheDir, adjustedPcm.getName() + ".wav");
        new PcmToWavUtil(44100,  AudioFormat.CHANNEL_IN_STEREO,
                2, AudioFormat.ENCODING_PCM_16BIT).pcmToWav(adjustedPcm.getAbsolutePath()
                , wavFile.getAbsolutePath());
        Log.i("tuch", "mixAudioTrack: 转换完毕");

        //        混合视频和音频
        mixVideoAndMusic(videoInput, output, startTimeUs, endTimeUs, wavFile);
    }

    public static float getAveFrameRate(String path) throws IOException {
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(path);
        int trackIndex = selectTrack(extractor, false);
        extractor.selectTrack(trackIndex);
        long lastSampleTimeUs = 0;
        int frameCount = 0;
        while (true) {
            long sampleTime = extractor.getSampleTime();
            if (sampleTime < 0) {
                break;
            } else {
                lastSampleTimeUs = sampleTime;
            }
            frameCount++;
            extractor.advance();
        }
        extractor.release();
        return frameCount / (lastSampleTimeUs / 1000f / 1000f);
    }

    private static void mixVideoAndMusic(String videoInput, String output, Integer startTimeUs, Integer endTimeUs, File wavFile) throws IOException {
        //        开始合成  新建一个空的轨道
        MediaMuxer mediaMuxer = new MediaMuxer(output, MediaMuxer.OutputFormat.MUXER_OUTPUT_MPEG_4);
        MediaExtractor oriExtrator = new MediaExtractor();
        oriExtrator.setDataSource(videoInput);
        int oriAudioIndex = selectTrack(oriExtrator, true);
//      获取原视频轨道的格式
        int oriVideoIndex = selectTrack(oriExtrator, false);
        MediaFormat oriVideoFormat = oriExtrator.getTrackFormat(oriVideoIndex);
//        将格式添加到设置进空的轨道中
        int muxerVideoIndex = mediaMuxer.addTrack(oriVideoFormat);
        MediaFormat oriAudioFormat = oriExtrator.getTrackFormat(oriAudioIndex);
        int  audioBitrate = oriAudioFormat.getInteger(MediaFormat.KEY_BIT_RATE);
        oriAudioFormat.setString(MediaFormat.KEY_MIME, MediaFormat.MIMETYPE_AUDIO_AAC);
        int muxerAudioIndex = mediaMuxer.addTrack(oriAudioFormat);
//        开始合成视频
        //重新写入音频
        mediaMuxer.start();

        MediaExtractor pcmExtrator = new MediaExtractor();
        pcmExtrator.setDataSource(wavFile.getAbsolutePath());
        int audioTrack =  selectTrack(pcmExtrator, true);
        pcmExtrator.selectTrack(audioTrack);
        MediaFormat pcmTrackFormat = pcmExtrator.getTrackFormat(audioTrack);
        int maxBufferSize = 0;
        if (pcmTrackFormat.containsKey(MediaFormat.KEY_MAX_INPUT_SIZE)) {
            maxBufferSize = pcmTrackFormat.getInteger(MediaFormat.KEY_MAX_INPUT_SIZE);
        } else {
            maxBufferSize = 100 * 1000;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        MediaFormat encodeFormat = MediaFormat.createAudioFormat(MediaFormat.MIMETYPE_AUDIO_AAC, 44100, 2);//参数对应-> mime type、采样率、声道数
        encodeFormat.setInteger(MediaFormat.KEY_BIT_RATE, audioBitrate);//比特率
        encodeFormat.setInteger(MediaFormat.KEY_AAC_PROFILE, MediaCodecInfo.CodecProfileLevel.AACObjectLC);
        encodeFormat.setInteger(MediaFormat.KEY_MAX_INPUT_SIZE, maxBufferSize);
        MediaCodec encoder = MediaCodec.createEncoderByType(MediaFormat.MIMETYPE_AUDIO_AAC);
        encoder.configure(encodeFormat, null, null, MediaCodec.CONFIGURE_FLAG_ENCODE);
        encoder.start();
        boolean encodeInputDone = false;
        boolean encodeDone = false;
        long lastAudioFrameTimeUs = -1;
        final int AAC_FRAME_TIME_US = 1024 * 1000 * 1000 / 44100;
        boolean detectTimeError = false;
     int TIMEOUT = 2500;
        try {
            while (!encodeDone) {
                int inputBufferIndex = encoder.dequeueInputBuffer(TIMEOUT);
                if (!encodeInputDone && inputBufferIndex >= 0) {
                    long sampleTime = pcmExtrator.getSampleTime();
                    if (sampleTime < 0) {
                        encodeInputDone = true;
                        encoder.queueInputBuffer(inputBufferIndex, 0, 0, 0, MediaCodec.BUFFER_FLAG_END_OF_STREAM);
                    } else {
                        int flags = pcmExtrator.getSampleFlags();
                        buffer.clear();
                        int size = pcmExtrator.readSampleData(buffer, 0);
                        ByteBuffer inputBuffer = encoder.getInputBuffer(inputBufferIndex);
                        inputBuffer.clear();
                        inputBuffer.put(buffer);
                        inputBuffer.position(0);
                        encoder.queueInputBuffer(inputBufferIndex, 0, size, sampleTime, flags);
                        pcmExtrator.advance();
                    }
                }

                while (true) {
                    int outputBufferIndex = encoder.dequeueOutputBuffer(info, TIMEOUT);
                    if (outputBufferIndex == MediaCodec.INFO_TRY_AGAIN_LATER) {
                        break;
                    } else if (outputBufferIndex == MediaCodec.INFO_OUTPUT_FORMAT_CHANGED) {
                        MediaFormat newFormat = encoder.getOutputFormat();
                    } else if (outputBufferIndex < 0) {
                        //ignore
                    } else {
                        if (info.flags == MediaCodec.BUFFER_FLAG_END_OF_STREAM) {
                            encodeDone = true;
                            break;
                        }
                        ByteBuffer encodeOutputBuffer = encoder.getOutputBuffer(outputBufferIndex);
                        if (!detectTimeError && lastAudioFrameTimeUs != -1 && info.presentationTimeUs < lastAudioFrameTimeUs + AAC_FRAME_TIME_US) {
                            //某些情况下帧时间会出错，目前未找到原因（系统相机录得双声道视频正常，我录的单声道视频不正常）
                            detectTimeError = true;
                        }
                        if (detectTimeError) {
                            info.presentationTimeUs = lastAudioFrameTimeUs + AAC_FRAME_TIME_US;
                            detectTimeError = false;
                        }
                        if (info.flags != MediaCodec.BUFFER_FLAG_CODEC_CONFIG) {
                            lastAudioFrameTimeUs = info.presentationTimeUs;
                        }
                        mediaMuxer.writeSampleData(muxerAudioIndex, encodeOutputBuffer, info);

                        encodeOutputBuffer.clear();
                        encoder.releaseOutputBuffer(outputBufferIndex, false);
                    }
                }
            }
            //重新将视频写入
            if (oriAudioIndex >= 0) {
                oriExtrator.unselectTrack(oriAudioIndex);
            }
            oriExtrator.selectTrack(oriVideoIndex);
            oriExtrator.seekTo(startTimeUs, MediaExtractor.SEEK_TO_PREVIOUS_SYNC);
            maxBufferSize = oriVideoFormat.getInteger(MediaFormat.KEY_MAX_INPUT_SIZE);
            int frameRate = oriVideoFormat.containsKey(MediaFormat.KEY_FRAME_RATE) ? oriVideoFormat.getInteger(MediaFormat.KEY_FRAME_RATE) : (int) Math.ceil(getAveFrameRate(videoInput));
            buffer = ByteBuffer.allocateDirect(maxBufferSize);
            final int VIDEO_FRAME_TIME_US = (int) (1000 * 1000f / frameRate);
            long lastVideoFrameTimeUs = -1;
            detectTimeError = false;
            while (true) {
                long sampleTimeUs = oriExtrator.getSampleTime();
                if (sampleTimeUs == -1) {
                    break;
                }
                if (sampleTimeUs < startTimeUs) {
                    oriExtrator.advance();
                    continue;
                }
                if (endTimeUs != null && sampleTimeUs > endTimeUs) {
                    break;
                }
                info.presentationTimeUs = sampleTimeUs - startTimeUs;
                info.flags = oriExtrator.getSampleFlags();
                info.size = oriExtrator.readSampleData(buffer, 0);
                if (info.size < 0) {
                    break;
                }
                //写入视频
                if (!detectTimeError && lastVideoFrameTimeUs != -1 && info.presentationTimeUs < lastVideoFrameTimeUs + VIDEO_FRAME_TIME_US) {
                    //某些视频帧时间会出错
                    detectTimeError = true;
                }
                if (detectTimeError) {
                    info.presentationTimeUs = lastVideoFrameTimeUs + VIDEO_FRAME_TIME_US;
                    detectTimeError = false;
                }
                if (info.flags != MediaCodec.BUFFER_FLAG_CODEC_CONFIG) {
                    lastVideoFrameTimeUs = info.presentationTimeUs;
                }
                mediaMuxer.writeSampleData(muxerVideoIndex, buffer, info);
                oriExtrator.advance();
            }
        } finally {
            try {
                pcmExtrator.release();
                oriExtrator.release();
                encoder.stop();
                encoder.release();
                mediaMuxer.release();
            } catch (Exception e) {
            }
        }
    }

    private static float normalizeVolume(int volume) {
        return volume / 100f * 1;
    }
    public static void mixPcm(String pcm1Path, String pcm2Path, String toPath
            , int volume1, int volume2) throws IOException {
        float vol1 = normalizeVolume(volume1);
        float vol2 = normalizeVolume(volume2);
        byte[] buffer1 = new byte[2048];
        byte[] buffer2 = new byte[2048];
        byte[] buffer3 = new byte[2048];

        FileInputStream is1 = new FileInputStream(pcm1Path);
        FileInputStream is2 = new FileInputStream(pcm2Path);

        FileOutputStream fileOutputStream = new FileOutputStream(toPath);
        boolean end1 = false, end2 = false;
        short temp2, temp1;
        int temp;
        try {
            while (!end1 || !end2) {
                if (!end1) {
                    end1 = (is1.read(buffer1) == -1);
                    System.arraycopy(buffer1, 0, buffer3, 0, buffer1.length);
                }
                if (!end2) {
                    end2 = (is2.read(buffer2) == -1);
                    for (int i = 0; i < buffer2.length; i += 2) {
                        temp1 = (short) ((buffer1[i] & 0xff) | (buffer1[i + 1] & 0xff) << 8);
                        temp2 = (short) ((buffer2[i] & 0xff) | (buffer2[i + 1] & 0xff) << 8);
                        temp = (int) (temp2 * vol2 + temp1 * vol1);
//                        两个字节  65535
                        if (temp > 32767) {
                            temp = 32767;

                        } else if (temp < -32768) {
                            temp = -32768;
                        }
                        buffer3[i] = (byte) (temp & 0xFF);
                        buffer3[i + 1] = (byte) ((temp >>> 8) & 0xFF);

                    }
                    fileOutputStream.write(buffer3);
                }
            }
        } catch (Exception e) {

        }




    }

    private static void decodeToPCM(String audioSource, String outPath, int startTimeUs, int endTimeUs) throws IOException {

//        解码    一致  音频 视频解码 没有区别
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(audioSource);
//        true 音频轨道   视频轨道 false
        int audioTrack = selectTrack(extractor, true);
        extractor.selectTrack(audioTrack);
//        异步seek到那一帧
        extractor.seekTo(startTimeUs, MediaExtractor.SEEK_TO_CLOSEST_SYNC);
//        拿到配置信息
        MediaFormat oriAudioFormat = extractor.getTrackFormat(audioTrack);

//        while  while
        int maxBufferSize;
        if (oriAudioFormat.containsKey(MediaFormat.KEY_MAX_INPUT_SIZE)) {
            maxBufferSize = oriAudioFormat.getInteger(MediaFormat.KEY_MAX_INPUT_SIZE);
        }else{
            maxBufferSize = 100 * 1000;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
//        info---->修饰  buffer信息    info size   presentationTimeUs
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();

// mediaCodec  家解码器   学习 举一反三   平时开发
        MediaCodec decoder = MediaCodec.createDecoderByType(oriAudioFormat.getString(MediaFormat.KEY_MIME));
// 软解
        //         //第一个参数是待解码的数据格式(也可用于编码操作);
//         第二个参数是设置surface，用来在其上绘制解码器解码出的数据；
//         第三个参数于数据加密有关；
//         第四个参数上1表示编码器， 0是否表示解码器
        decoder.configure(oriAudioFormat, null, null, 0);
        decoder.start();


//        解码
//解码到视频末尾
        boolean decodeDone = false;
//        读到一帧数据
        boolean decodeInputDone = false;
        final int TIMEOUT_US = 2500;
        File pcmFile = new File(outPath);

        FileChannel writeChannel = new FileOutputStream(pcmFile).getChannel();
        try {
        while (!decodeDone) {
//读帧头
            if (!decodeInputDone) {
                boolean eof = false;
//                空的油桶  的缩影  decodeInputIndex  1
                int decodeInputIndex = decoder.dequeueInputBuffer(TIMEOUT_US);
                if (decodeInputIndex >= 0) {
//      什么时候 该往里面放  播放时间
                    long sampleTimeUs = extractor.getSampleTime();
                    if (sampleTimeUs == -1) {
//                        视频末尾
                        eof = true;
                    } else if (sampleTimeUs < startTimeUs) {
//                        前面 跳过去了
                        extractor.advance();
                    } else if (sampleTimeUs > endTimeUs) {
                        eof = true;
                    }
//                    结束
                    if (eof) {
//                        帧内不用解码
                        decodeInputDone = true;
                        decoder.queueInputBuffer(decodeInputIndex, 0, 0, 0, MediaCodec.BUFFER_FLAG_END_OF_STREAM);
                    }else {
//                        放进去了
                        info.size=extractor.readSampleData(buffer, 0);

                        info.presentationTimeUs = sampleTimeUs;
                        info.flags = extractor.getSampleFlags();
//                        中石化的油桶队列
//
                        ByteBuffer inputBuffer= decoder.getInputBuffer(decodeInputIndex);
                        inputBuffer.put(buffer);
//是由厂商

                        decoder.queueInputBuffer(decodeInputIndex, 0, info.size,
                                info.presentationTimeUs, info.flags);
                        extractor.advance();
//                        芯片内部进行解码     解码能力
                    }


                }




            }
            while (!decodeDone) {
//                读取帧内信息
//outputBufferIndex   2
                int outputBufferIndex = decoder.dequeueOutputBuffer(info, TIMEOUT_US);

                if (outputBufferIndex == MediaCodec.INFO_TRY_AGAIN_LATER) {
                    break;
                }else if (outputBufferIndex >= 0)   {

                    if (info.flags == MediaCodec.BUFFER_FLAG_END_OF_STREAM) {
                        decodeDone = true;
                    }else {
//正常解码   后的原始数据
                        ByteBuffer decodeOutputBuffer =decoder.getOutputBuffer(outputBufferIndex);
                        writeChannel.write(decodeOutputBuffer);

                    }
                    decoder.releaseOutputBuffer(outputBufferIndex, false);

                }

            }
        }  } finally {
            writeChannel.close();
            extractor.release();
            decoder.stop();
            decoder.release();
        }












    }
    public static int selectTrack(MediaExtractor extractor, boolean audio) {

        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; i++) {
//            HAshMap
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString(MediaFormat.KEY_MIME);
            if (audio) {
                if (mime.startsWith("audio/")) {
                    return i;
                }
            }else {
                if (mime.startsWith("video/")) {
                    return i;
                }
            }

        }
        return -1;

    }
}
