package com.maniu.douyinsample;

import androidx.appcompat.app.AppCompatActivity;

import android.Manifest;
import android.app.Activity;
import android.content.pm.PackageManager;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SeekBar;
import android.widget.Toast;
import android.widget.VideoView;

import com.jaygoo.widget.RangeSeekBar;

import java.io.File;
import java.io.IOException;

public class MainActivity extends AppCompatActivity {
    VideoView videoView;
    RangeSeekBar rangeSeekBar;
    SeekBar musicSeekBar;
    SeekBar voiceSeekBar;
    int musicVolume=100;
    int voiceVolume=100;
    Runnable runnable;
    int duration = 0;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        checkPermission(this);
        initView();
    }
    private void initView() {
        videoView = findViewById(R.id.videoView);
        rangeSeekBar = findViewById(R.id.rangeSeekBar);
        musicSeekBar = findViewById(R.id.musicSeekBar);
        voiceSeekBar = findViewById(R.id.voiceSeekBar);
        musicSeekBar.setMax(100);
        voiceSeekBar.setMax(100);
        musicSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                musicVolume = progress;
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });
        voiceSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                voiceVolume = progress;
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
            }
            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });
    }
    @Override
    protected void onResume() {
        super.onResume();
        startPlay(new File(Environment.getExternalStorageDirectory(), "/movie/input.mp4").getAbsolutePath());
    }
    private void startPlay(String path) {
        ViewGroup.LayoutParams layoutParams = videoView.getLayoutParams();
        layoutParams.height = 675;
        layoutParams.width = 1285;
        videoView.setLayoutParams(layoutParams);
        videoView.setVideoPath(path);

        videoView.start();
        videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {

            @Override
            public void onPrepared(MediaPlayer mp) {
                duration = mp.getDuration() / 1000;
                mp.setLooping(true);
                rangeSeekBar.setRange(0, duration);
                rangeSeekBar.setValue(0, duration);
                rangeSeekBar.setEnabled(true);
                rangeSeekBar.requestLayout();
                rangeSeekBar.setOnRangeChangedListener(new RangeSeekBar.OnRangeChangedListener() {
                    @Override
                    public void onRangeChanged(RangeSeekBar view, float min, float max, boolean isFromUser) {
                        videoView.seekTo((int) min * 1000);
                    }
                });
                final Handler handler = new Handler();
                runnable = new Runnable() {
                    @Override
                    public void run() {
                        if (videoView.getCurrentPosition() >= rangeSeekBar.getCurrentRange()[1] * 1000) {
                            videoView.seekTo((int) rangeSeekBar.getCurrentRange()[0] * 1000);
                        }
                        handler.postDelayed(runnable, 1000);
                    }
                };
                handler.postDelayed(runnable, 1000);
            }
        });
    }

    public static boolean checkPermission(
            Activity activity) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M && activity.checkSelfPermission(
                Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
            activity.requestPermissions(new String[]{
                    Manifest.permission.READ_EXTERNAL_STORAGE,
                    Manifest.permission.WRITE_EXTERNAL_STORAGE
            }, 1);

        }
        return false;
    }
    public void music(View view) {
        File cacheDir = new File(Environment.getExternalStorageDirectory(), "movie");
        final File videoFile = new File(cacheDir, "input.mp4");
        final File audioFile = new File(cacheDir, "music.mp3");
//        输出剪辑后的视频
        final File outputFile = new File(cacheDir, "output.mp4");

//
        final int start = (int) (rangeSeekBar.getCurrentRange()[0] * 1000 * 1000);

        final int end = (int) (rangeSeekBar.getCurrentRange()[1] * 1000 * 1000);
//
        new Thread() {
            @Override
            public void run() {
                try {
                    VideoEditor.mixAudioTrack(MainActivity.this,
                            videoFile.getAbsolutePath(),
                            audioFile.getAbsolutePath(),
                            outputFile.getAbsolutePath(), start, end, voiceVolume, musicVolume

                    );

                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            startPlay(new File(Environment.getExternalStorageDirectory(), "/movie/output.mp4").getAbsolutePath());
                            Toast.makeText(MainActivity.this, "剪辑完毕", Toast.LENGTH_SHORT).show();
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }
}
