package com.example.toastjavassist

import com.android.SdkConstants
import com.android.build.api.transform.Format
import com.android.build.api.transform.QualifiedContent
import com.android.build.api.transform.Transform
import com.android.build.api.transform.TransformException
import com.android.build.api.transform.TransformInvocation
import com.android.build.gradle.internal.pipeline.TransformManager
import javassist.ClassPool
import javassist.CtClass
import javassist.CtField
import javassist.CtMethod
import org.apache.commons.codec.digest.DigestUtils
import org.apache.commons.io.FileUtils
import org.gradle.api.Project

public class ModifyTransform extends Transform {
    def project
//定义一个classpool
    def pool = ClassPool.default
    private static final def CLICK_LISTENER =
            "android.view.View\$OnClickListener"


//Hashmap
    ModifyTransform(Project project) {
        this.project = project
    }

    @Override
    String getName() {
        return "DavidTransform"
    }

    @Override
    Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS
    }

    @Override
    Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_PROJECT
    }
//增量编译  全量编译
    @Override
    boolean isIncremental() {
        return false
    }

    @Override
    void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        super.transform(transformInvocation)
//        手动修改class字节码文件
        project.android.bootClasspath.each {
//池
            pool.appendClassPath(it.absolutePath)
        }

//        classpool的内容
        transformInvocation.inputs.each {
//

            transformInvocation.inputs.each {
                it.jarInputs.each {
                    pool.insertClassPath(it.file.absolutePath)

                    // 重命名输出文件（同目录copyFile会冲突）
                    def jarName = it.name
                    def md5Name = DigestUtils.md5Hex(it.file.getAbsolutePath())
                    if (jarName.endsWith(".jar")) {
                        jarName = jarName.substring(0, jarName.length() - 4)
                    }
                    def dest = transformInvocation.outputProvider.getContentLocation(
                            jarName + md5Name, it.contentTypes, it.scopes, Format.JAR)
                    FileUtils.copyFile(it.file, dest)
                }

            }
            it.directoryInputs.each {
//找到class路径
                def preFileName = it.file.absolutePath
//                将路径插入到classpool 去
                pool.insertClassPath(preFileName)
//                找到你要修改的类
                findTarget(it.file, preFileName)
                // 获取output目录
                def dest = transformInvocation.outputProvider.getContentLocation(
                        it.name,
                        it.contentTypes,
                        it.scopes,
                        Format.DIRECTORY)

                println "copy directory: " + it.file.absolutePath
                println "dest directory: " + dest.absolutePath
                // 将input的目录复制到output指定目录
                FileUtils.copyDirectory(it.file, dest)
            }
        }

    }

    private void findTarget(File dir, String fileName) {

        if (dir.isDirectory()) {
            dir.listFiles().each {
                findTarget(it, fileName)
            }
        } else {
            modify(dir, fileName)
        }

    }
//如果是文件
    private void modify(File dir, String fileName) {
//路径  com
        def filePath = dir.absolutePath
//        过滤非class
        if (!filePath.endsWith(SdkConstants.DOT_CLASS)) {
            return
        }
//        过滤 R  class
        if (filePath.contains('R$') || filePath.contains('R.class')
                || filePath.contains("BuildConfig.class")) {
            return
        }
//        类进行修改
//       javac\debug\compileDebugJavaWithJavac\classes\com\example\davidjavassist\MainActivity.class
        def className = filePath.replace(fileName, "")
                .replace("\\", ".")
                .replace("/", ".")
        def name = className.replace(SdkConstants.DOT_CLASS, "")
                .substring(1)
//        com\example\davidjavassist.MainActivity.
//name   全类名
//        字节码手术刀  class    字节码  二进制
        CtClass ctClass = pool.get(name)
//        实现接口
        CtClass[] interfaces = ctClass.getInterfaces()
        if (interfaces.contains(pool.get(CLICK_LISTENER))) {
            if (name.contains("\$")) {
                println "class is inner class：" + ctClass.name
                println "CtClass: " + ctClass
                CtClass outer = pool.get(name.substring(0, name.indexOf("\$")))

                CtField field = ctClass.getFields().find {
                    return it.type == outer
                }
                if (field != null) {
                    println "fieldStr: " + field.name
                    def body = "android.widget.Toast.makeText(" + field.name + "," +
                            "\"javassist\", android.widget.Toast.LENGTH_SHORT).show();"
                    addCode(ctClass, body, fileName)
                }
            } else {
                println "class is outer class: " + ctClass.name
                //更改onClick函数   字节码手术刀操作
//        判断 class   是不是   Listener
                def body = "android.widget.Toast.makeText" +
                        "(\$1.getContext(), \"David  出来了\"," +
                        " android.widget.Toast.LENGTH_SHORT).show();"
                addCode(ctClass, body, fileName)
            }

        }
    }

    private void addCode(CtClass ctClass, String body, String fileName) {
//        还原
        ctClass.defrost()
        CtMethod method = ctClass.getDeclaredMethod("onClick", pool.get("android.view.View"))
        method.insertAfter(body)

        ctClass.writeFile(fileName)
        ctClass.detach()
        println "write file: " + fileName + "\\" + ctClass.name
        println "modify method: " + method.name + " succeed"


    }


}
