package com.mn.nsl_lib.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import com.mn.nsl_lib.NSLLib;
import com.mn.nsl_lib.bean.NetworkType;

public class NSLUtil {
    private static final String TAG = "NSLUtil";

    /**
     * 判断网络是否可用
     *
     * @return
     */
    @SuppressLint("MissingPermission")
    public static boolean isNetworkAvailable() {
        ConnectivityManager cm = getConnectivityManager();
        NetworkInfo[] networkInfo = cm.getAllNetworkInfo();
        if (networkInfo != null) {
            for (NetworkInfo info : networkInfo) {
                if (info.getState() == NetworkInfo.State.CONNECTED) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 获取当前网络类型
     *
     * @return
     */
    @SuppressLint("MissingPermission")
    public static NetworkType getNetworkType() {
        ConnectivityManager connectivityManager = getConnectivityManager();
        if (connectivityManager == null) {
            return NetworkType.NONE;
        }

        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return NetworkType.NONE;
        }
        int type = networkInfo.getType();
        if (type == ConnectivityManager.TYPE_WIFI) {
            return NetworkType.WIFI;
        }
        else if (type == ConnectivityManager.TYPE_MOBILE) {
            return NetworkType.MOBILE;
        }
        return NetworkType.NONE;
    }

    /**
     * 获取 ConnectivityManager
     *
     * @return
     */
    public static ConnectivityManager getConnectivityManager() {
        //Binder
        ConnectivityManager connectivityManager =
                (ConnectivityManager) NSLLib.getInstance().getApplication()
                        .getSystemService(Context.CONNECTIVITY_SERVICE);
        return connectivityManager;
    }

}
