package com.mn.nsl_lib.handler;

import android.util.Log;

import com.mn.nsl_lib.NSLLib;
import com.mn.nsl_lib.annotation.NSLSubscribe;
import com.mn.nsl_lib.bean.MethodInvoke;
import com.mn.nsl_lib.bean.NetworkType;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventHandler {
    private static final String TAG = "EventHandler";
    private static volatile EventHandler mInstance;
    private Map<Object, List<MethodInvoke>> methodCacheMap;//方法缓存表

    private EventHandler() {
        methodCacheMap = new HashMap<>();
    }

    public static EventHandler getInstance() {
        if (mInstance == null) {
            synchronized (NSLLib.class) {
                if (mInstance == null) {
                    mInstance = new EventHandler();
                }
            }
        }
        return mInstance;
    }

    public void register(Object subscriber) {
        List<MethodInvoke> methodInvokes = methodCacheMap.get(subscriber);
        if (methodInvokes == null) {
            Log.e(TAG, "methodInvokes == null");
            methodInvokes = findAnnotationMethod(subscriber);
            methodCacheMap.put(subscriber, methodInvokes);
        }
    }

    /**
     * 获取注解方法
     *
     * @param subscriber
     * @return
     */
    private List<MethodInvoke> findAnnotationMethod(Object subscriber) {
        List<MethodInvoke> methodInvokes = new ArrayList<>();
        Method[] methods = subscriber.getClass().getDeclaredMethods();
        for (Method method : methods) {
            NSLSubscribe subscribe = method.getAnnotation(NSLSubscribe.class);
            if (subscribe == null) {
                continue;
            }
            // 方法返回值校验
            Type returnType = method.getGenericReturnType();
            if (!"void".equals(returnType.toString())) {
                Log.e(TAG, method.getName() + "方法返回必须是void");
                continue;
            }
            // 参数校验
            Class<?>[] parameterTypes = method.getParameterTypes();
            // MethodInvoke methodInvoke;
            // if (parameterTypes.length == 0) {
            //     methodInvoke = new MethodInvoke(method, subscribe.mode(), null);
            // }
            // else if (parameterTypes.length == 1) {
            //     methodInvoke = new MethodInvoke(method, subscribe.mode(), parameterTypes[0]);
            // }
            // else {
            //     throw new IllegalArgumentException(method.getName() +
            //             " 至少要有1个参数");
            // }
            if (parameterTypes == null || parameterTypes.length != 1 ||
                    parameterTypes[0].getClass().isAssignableFrom(NetworkType.class.getClass()) ==
                            false) {
                Log.e(TAG,
                        method.getName() + " 方法 只能有一个参数，并且参数类型 必须为:" + NetworkType.class.getName());
                continue;
            }
            methodInvokes.add(new MethodInvoke(method, subscribe.mode(), parameterTypes[0]));
        }
        return methodInvokes;
    }

    public void unRegister(Object subscriber) {
        if (!methodCacheMap.isEmpty()) {
            methodCacheMap.remove(subscriber);
        }
        Log.e(TAG, subscriber.getClass().getName() + "网络监听注销成功");
    }

    public void unRegisterAll() {
        if (!methodCacheMap.isEmpty()) {
            methodCacheMap.clear();
        }
        Log.e(TAG, "网络监听全部注销");
    }

    public void send(NetworkType networkType) {
        if (methodCacheMap == null || methodCacheMap.isEmpty()) {
            Log.e(TAG, "send--methodCacheMap == null");
            //     return;
        }
        Set<Object> subscribers = methodCacheMap.keySet();
        for (final Object subscriber : subscribers) {
            List<MethodInvoke> methodInvokes = methodCacheMap.get(subscriber);
            if (methodInvokes != null) {
                for (MethodInvoke methodInvoke : methodInvokes) {
                    switch (methodInvoke.getSubscribeMode()) {
                        case AUTO:
                            invoke(methodInvoke, subscriber, networkType);
                            break;
                        case WIFI:
                            if (networkType == NetworkType.WIFI ||
                                    networkType == NetworkType.NONE) {
                                invoke(methodInvoke, subscriber, networkType);
                            }
                            break;
                        // case WIFI_CONNECT:
                        //     if (networkType == NetworkType.WIFI)
                        //         invoke(methodInvoke, subscriber, networkType);
                        //     break;
                        case MOBILE:
                            if (networkType == NetworkType.MOBILE ||
                                    networkType == NetworkType.NONE) {
                                invoke(methodInvoke, subscriber, networkType);
                            }
                            break;
                        // case MOBILE_CONNECT:
                        //     if (networkType == NetworkType.MOBILE) {
                        //         invoke(methodInvoke, subscriber, networkType);
                        //     }
                        //     break;
                        case NONE:
                            if (networkType == NetworkType.NONE) {
                                invoke(methodInvoke, subscriber, networkType);
                            }
                            // invoke(methodInvoke, subscriber, networkType);
                            break;
                    }
                }
            }
        }
    }

    private void invoke(MethodInvoke methodInvoke, Object subscriber, NetworkType networkType) {
        try {
            Method method = methodInvoke.getMethod();
            method.invoke(subscriber, networkType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}
