package com.mn.nsl_lib.bean;

import java.lang.reflect.Method;

/**
 * 要反射执行的方法封装类
 */
public class MethodInvoke {
    //要反射执行的方法
    private Method method;
    //方法注解的参数(订阅哪种网络类型)
    private SubscribeMode subscribeMode;
    //方法的参数类型
    private Class<?> paramType;

    public MethodInvoke(Method method, SubscribeMode subscribeMode, Class<?> paramType) {
        this.method = method;
        this.method.setAccessible(true);
        this.subscribeMode = subscribeMode;
        this.paramType = paramType;
    }

    public Method getMethod() {
        return method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public SubscribeMode getSubscribeMode() {
        return subscribeMode;
    }

    public void setSubscribeMode(SubscribeMode subscribeMode) {
        this.subscribeMode = subscribeMode;
    }

    public Class<?> getParamType() {
        return paramType;
    }

    public void setParamType(Class<?> paramType) {
        this.paramType = paramType;
    }
}
