package com.mn.nsl_lib;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;

import com.mn.nsl_lib.bean.NetworkType;
import com.mn.nsl_lib.utils.NSLUtil;

@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
public class NetworkCallbackImpl extends ConnectivityManager.NetworkCallback {
    private static final String TAG = "NetworkCallbackImpl";
    private NSLCallback callback;

    public NetworkCallbackImpl(NSLCallback callback){
        this.callback = callback;
    }

    @Override
    public void onAvailable(@NonNull Network network) {
        super.onAvailable(network);
        NetworkType networkType = NSLUtil.getNetworkType();
        Log.e(TAG, networkType.name() + "网络已连接");
        callbackState(networkType);
    }

    @Override
    public void onLost(@NonNull Network network) {
        super.onLost(network);
        Log.e(TAG, "网络已断开");
        callbackState(NetworkType.NONE);
    }

    @Override
    public void onCapabilitiesChanged(@NonNull Network network,
                                      @NonNull NetworkCapabilities networkCapabilities) {
        super.onCapabilitiesChanged(network, networkCapabilities);
        if (networkCapabilities.hasCapability(NetworkCapabilities.NET_CAPABILITY_VALIDATED)) {
            if (networkCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_WIFI)) {
                //wifi
                callbackState(NetworkType.WIFI);
            }
            else if (networkCapabilities.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR)) {
                //蜂窝网
                callbackState(NetworkType.MOBILE);
            }
        }

    }

    private void callbackState(NetworkType networkType) {
        if (callback != null){
            callback.onStatusChanged(networkType);
         }else{
            throw new RuntimeException("callbak 为空");
        }
    }
}
