package com.mn.nsl_lib;

import android.annotation.SuppressLint;
import android.app.Application;
import android.net.ConnectivityManager;
import android.net.NetworkRequest;
import android.os.Build;

import com.mn.nsl_lib.bean.NetworkType;
import com.mn.nsl_lib.handler.EventHandler;
import com.mn.nsl_lib.utils.NSLUtil;

public class NSLLib implements NSLCallback {
    private static final String TAG = "NSLLib";
    private static volatile NSLLib mInstance;
    private Application mApplication;
    private NetworkCallbackImpl mNetworkCallback;
    private EventHandler mEventHandler;

    private NSLLib() {
        mEventHandler = EventHandler.getInstance();
    }

    public static NSLLib getInstance() {
        if (mInstance == null) {
            synchronized (NSLLib.class) {
                if (mInstance == null) {
                    mInstance = new NSLLib();
                }
            }
        }
        return mInstance;
    }

    public Application getApplication() {
        if (mApplication == null) {
            throw new RuntimeException("NetworkManager.application == null");
        }
        return mApplication;
    }

    @SuppressLint("MissingPermission")
    public void init(Application application) {
        this.mApplication = application;
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            //使用广播 方式
        }
        else {
            mNetworkCallback = new NetworkCallbackImpl(this);
            //ConnectivityManager
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            NetworkRequest request = builder.build();

            ConnectivityManager cm = NSLUtil.getConnectivityManager();
            if (cm != null) {
                cm.registerNetworkCallback(request, mNetworkCallback);
            }
        }
    }

    public NetworkType getNetworkType() {
        return NSLUtil.getNetworkType();
    }

    public void register(Object subscriber) {
        mEventHandler.register(subscriber);
    }

    public void unRegister(Object subscriber) {
        mEventHandler.unRegister(subscriber);
    }

    @Override
    public void onStatusChanged(NetworkType networkType) {
        mEventHandler.send(networkType);
    }
}
