package com.mn.nsl_0709;

import android.os.Bundle;
import android.widget.TextView;

import com.mn.nsl_lib.NSLLib;
import com.mn.nsl_lib.annotation.NSLSubscribe;
import com.mn.nsl_lib.bean.NetworkType;
import com.mn.nsl_lib.bean.SubscribeMode;

public class MainActivity extends NSLActivity {
    private static final String TAG = "MainActivity";
    private TextView tv;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        tv = findViewById(R.id.tv);
        tv.setText("当前网络为：" + NSLLib.getInstance().getNetworkType().name());
        //NetworkStatusListener

    }

    /**
     * 网络监听方法
     * @param networkType 网络类型
     */
    @NSLSubscribe(mode = SubscribeMode.AUTO)
    public void netChanged(final NetworkType networkType) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                tv.setText("当前网络为：" + networkType.name());
            }
        });
    }

    @NSLSubscribe(mode = SubscribeMode.WIFI)
    public void netChangedMobie(final NetworkType networkType) {

    }
}