package com.mn.icc_0706;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;

import androidx.appcompat.app.AppCompatActivity;

import com.mn.icc.lib.ICCLib;
import com.mn.icc.lib.ICCTag;


public class MainActivity extends AppCompatActivity {
    private static final String TAG = "MainActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        ICCLib.getDefault().register(this);
    }

    //要被执行 反射
    @ICCTag({"login"})
    private void login(String name) {
        Log.e(TAG, "login success: " + name);
    }

    @ICCTag({"register"})
    private void register(String name) {
        Log.e(TAG, "register success: " + name);
    }


    public void startLogin(View view) {
        startActivity(new Intent(this, LoginActivity.class));
    }

    public void startRegister(View view) {
        startActivity(new Intent(this, RegisterActivity.class));
    }
}
