#include <jni.h>
#include <string>
#include <android/log.h>
#include <android/bitmap.h>
extern "C"
{
#include "gif_lib.h"
}

#define  argb(a,r,g,b) ( ((a) & 0xff) << 24 ) | ( ((b) & 0xff) << 16 ) | ( ((g) & 0xff) << 8 ) | ((r) & 0xff)

typedef  struct GifBean{
    int current_frame;
    int total_frame;
    int *dealys;
}GifBean;
extern "C"
{
//    渲染bitmap
void drawFrame1(GifFileType *gifFileType, GifBean *gifBean, AndroidBitmapInfo info, void *pixels) {
//当前帧 一定要拿到         拿到当前帧
    SavedImage savedImage = gifFileType->SavedImages[gifBean->current_frame];
    GifImageDesc frameInfo=savedImage.ImageDesc;
//    gif数据存放在哪 colorMapObject 颜色数据拿到了   数组  ---》索引
//  SavedImage Gif 一帧的里面 数据索引
    int  pointPixel;
//    辅助 变量  索引
    //整幅图片的首地址
    int* px = (int *)pixels;

    //  每一行的首地址
    int *line;
    ColorMapObject *colorMapObject = frameInfo.ColorMap;
    GifByteType  gifByteType;
    GifColorType gifColorType;
    for (int y = frameInfo.Top; y <frameInfo.Top+frameInfo.Height ; ++y) {
        line = px;
        for (int x = frameInfo.Left; x < frameInfo.Left + frameInfo.Width; ++x) {
//            gif索引
            pointPixel = (y - frameInfo.Top) * frameInfo.Width + (x - frameInfo.Left);
//            拿到的是颜色表对应的索引
            gifByteType =savedImage.RasterBits[pointPixel];
//            真正拿到颜色
            gifColorType= colorMapObject->Colors[gifByteType];
            line[x] = argb(255, gifColorType.Red, gifColorType.Green, gifColorType.Blue);
            //256红色  0#ff0000  NDL ：底层绘制Bitmap与图像解析技术  opencv 视频
//            bitmap索引  目标     gif 索引  元数据
//            line[x]    =   256;
        }
//        i++
        px = (int *) ((char *) px + info.stride);
    }

}
JNIEXPORT jlong JNICALL
Java_com_maniu_gifmaniu_GifHandler_loadGif(JNIEnv *env, jclass clazz, jstring path_) {
//初始化  本质加载一个gif文件
    const char *path = env->GetStringUTFChars(path_, 0);
    int *Error;
    GifFileType * gifFileType=DGifOpenFileName(path, Error);
//    初始化内部结构体对象
    DGifSlurp(gifFileType);
//    GifBean gifBean= new GifBean();
    GifBean *gifBean = static_cast<GifBean *>(malloc(sizeof(GifBean)));
    //    清空内存地址
    memset(gifBean, 0, sizeof(GifBean));
    gifFileType->UserData = gifBean;
    gifBean->current_frame = 0;
//    总共多少帧
    gifBean->total_frame = gifFileType->ImageCount;
//    难题一   怎么知道播放时间的  固定  不去  时间
    env->ReleaseStringUTFChars(path_, path);
    return (jlong) gifFileType;

}
JNIEXPORT jint JNICALL
Java_com_maniu_gifmaniu_GifHandler_getWidth(JNIEnv *env, jclass clazz, jlong ndkGif) {
    GifFileType *gifFileType = reinterpret_cast<GifFileType *>(ndkGif);
    return gifFileType->SWidth;
}
JNIEXPORT jint JNICALL
Java_com_maniu_gifmaniu_GifHandler_getHeight(JNIEnv *env, jclass clazz, jlong ndkGif) {
    GifFileType *gifFileType = reinterpret_cast<GifFileType *>(ndkGif);
    return gifFileType->SHeight;
}
//bitmap----->空白的纸
JNIEXPORT jint JNICALL
Java_com_maniu_gifmaniu_GifHandler_updateFrame(JNIEnv *env, jclass clazz, jobject bitmap,
                                               jlong ndkGif) {
//    渲染  该怎么办

    GifFileType *gifFileType= (GifFileType *)ndkGif;
    GifBean * gifBean= (GifBean *) gifFileType->UserData;
//        渲染了一帧
//真正实现底层渲染Bitmap
    AndroidBitmapInfo  info;
//    info  入参出参对象
    AndroidBitmap_getInfo(env, bitmap, &info);
//    NDK  david 图像 --》java对象  -----》数组 缓冲区
    void *pixels;
//    图像转换成一个二位数组   像素
    AndroidBitmap_lockPixels(env, bitmap, &pixels);

    drawFrame1(gifFileType, gifBean, info, pixels);


    gifBean->current_frame += 1;
//    LOGE("当前帧  %d  ",gifBean->current_frame);
    if (gifBean->current_frame >= gifBean->total_frame - 1) {
//        从头播放
        gifBean->current_frame = 0;
    }
    AndroidBitmap_unlockPixels(env, bitmap);
    return 100;
}

}
