package com.maniu.maniuproxy;

import android.view.View;

import com.maniu.maniuproxy.annotion.ContentView;
import com.maniu.maniuproxy.annotion.EventBase;
import com.maniu.maniuproxy.annotion.OnClick;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class Utils {
    public static void inject(Object context) throws  Exception {

//        setContentView
        Class<?> activityClass=context.getClass();
        ContentView contentView = activityClass.getAnnotation(ContentView.class);
        if (contentView != null) {
            int layoutId = contentView.value();
            Method contentMethod=context.getClass().getMethod("setContentView",int.class);
            contentMethod.invoke(context, layoutId);
        }



//        架构  反射
        Class<?> clazz = context.getClass();
        Method[] methods = clazz.getDeclaredMethods();
        for (Method method : methods) {
            Annotation[] annotations = method.getAnnotations();
            EventBase eventBase = null;
            int[] viewId = null;
            for (Annotation annotation : annotations) {
                Class<?> annotionType = annotation.annotationType();
                 eventBase = annotionType.getAnnotation(EventBase.class);
                Method valueMethod = annotionType.getDeclaredMethod("value");
                viewId= (int[]) valueMethod.invoke(annotation);
                if (eventBase != null) {
                    break;
                }
            }
            if (eventBase == null || viewId == null) {
                continue;
            }
// setOnClickListener  activirty   1     View 2
            String listenerSetter = eventBase.listenerSetter();
//            OnClickListener
            Class<?> listenerType = eventBase.listenerType();
//            onClick
            String callBackMethod = eventBase.callbackMethod();

            for (int id : viewId) {
                Method findViewById=clazz.getMethod("findViewById",int.class);
                View view = (View) findViewById.invoke(context, id);
                if (view == null) {
                    continue;
                }
//                view.setOnClickListener(new View.OnClickListener() {
//                    @Override
//                    public void onClick(View v) {
//
//                    }
//                });
                Method setOnClickListener=view.getClass().getMethod(listenerSetter, listenerType);
                ListenerInvocationHandler listenerInvocationHandler =
                        new ListenerInvocationHandler(context, method);
                Object proxy = Proxy.newProxyInstance(listenerType.getClassLoader(),
                        new Class[]{listenerType}, listenerInvocationHandler);
                setOnClickListener.invoke(view, proxy);
            }

        }


        /**
         *    view.setOnClickListener(new View.OnClickListener() {
         *             @Override
         *             public void onClick(View v) {
         *
         *             }
         *         });
         */



    }
}
