package com.dongnao.skindavid;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.v4.view.LayoutInflaterFactory;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

import static android.content.ContentValues.TAG;

/**
 * Created by Administrator on 2018/2/8 0008.
 */

public class SkinFactory implements LayoutInflaterFactory {
    private List<SkinView> skinViewList = new ArrayList<>();
    private static final String[] prefixList = {
            "android.widget.",
            "android.view.",
            "android.webkit."
    };
    private List list;
    @Override
    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        Log.i(TAG, "onCreateView: "+name);
//name  --->View  反射     ----》全类名
        View view=null;
        if(name.contains(".")){
//            自定义控件
            view = createView(context, attrs, name);
        }else {
//            系统控件
            for (String pre : prefixList) {
                view = createView(context, attrs, pre + name);
                if (view != null) {
                    break;
                }
            }
        }
//       收集需要换肤的View
        if (view != null) {
            parseSkinView(context,attrs,view);
        }

        return view;
    }

    private void parseSkinView(Context context, AttributeSet attrs, View view) {
            List<SkinItem> list = new ArrayList<>();
            for (int i=0;i<attrs.getAttributeCount();i++) {
//                layout_width
                String attrname = attrs.getAttributeName(i);
                String idValues=attrs.getAttributeValue(i);
                Log.i("david"," name  "+attrname +"  idValue  "+idValues);
                if (attrname.equals("background") || attrname.equals("textColor")) {
// android:textColor="@android:color/colorAccent"
                    int id = Integer.parseInt(idValues.substring(1));
                    String entryName = context.getResources().getResourceEntryName(id);
                    String typeName=context.getResources().getResourceTypeName(id);
                    SkinItem skinItem = new SkinItem(attrname, id, entryName, typeName);
                    list.add(skinItem);
                }
            }

//            换肤
        if (!list.isEmpty()) {
            SkinView skinView = new SkinView(view, list);
            skinViewList.add(skinView);
            skinView.apply();
        }
    }

    public void apply() {
        for (SkinView skinView : skinViewList) {
            skinView.apply();
        }
    }
    class SkinView{
        private View view;
        private List<SkinItem> list;

        public SkinView(View view, List<SkinItem> list) {
            this.view = view;
            this.list = list;
        }
//        换肤的开关
        @TargetApi(Build.VERSION_CODES.JELLY_BEAN)
        public  void apply(){
            for (SkinItem skinItem : list) {
                if (skinItem.attrName.equals("textColor")) {
                    if (view instanceof TextView) {
                        ((TextView)view).setTextColor(SkinManager.getInstance().getColor(skinItem.getRefId()));
                    }
                } else if (skinItem.attrName.equals("background")) {
                    if ("color".equals(skinItem.getTypeName())) {
                        view.setBackgroundColor(SkinManager.getInstance().getColor(skinItem.getRefId()));
                    }else if("drawable".equals(skinItem.getTypeName())){
                        view.setBackground(SkinManager.getInstance().getDrawable(skinItem.getRefId()));
                    }
                }
            }
        }

    }
    class SkinItem{
//        单个皮肤属性
//backgroud        textColor
        String  attrName;
//        20164454545
        int refId;
//        colorPrimary
        String entryName;
//        color   drawable
        String typeName;

        public SkinItem(String attrName, int refId, String entryName, String typeName) {
            this.attrName = attrName;
            this.refId = refId;
            this.entryName = entryName;
            this.typeName = typeName;
        }

        public String getAttrName() {
            return attrName;
        }

        public int getRefId() {
            return refId;
        }

        public String getEntryName() {
            return entryName;
        }

        public String getTypeName() {
            return typeName;
        }
    }


    //包名
    private View createView(Context context, AttributeSet attrs, String name) {
        try {
            Class viewClazz = context.getClassLoader().loadClass(name);
            Constructor<? extends View> constructor = viewClazz.getConstructor(new
                    Class[]{Context.class, AttributeSet.class});
            return constructor.newInstance(context,attrs);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
