package com.maniu.davidfix;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.TextView;

import java.io.File;
import java.lang.reflect.Method;

public class MainActivity extends AppCompatActivity {

    TextView textView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        verifyStoragePermissions(this);
        textView = (TextView) findViewById(R.id.result);
        Method method;
    }
//    加载刚才的修复包
    public void caclutor(View view) {
//        重启  tinker  1  第三个 热修复   hotfix  ---》arm指令 引用
        Caclutor caclutor = new Caclutor();

        textView.setText( caclutor.hashCode()+"");
    }
    public   void verifyStoragePermissions(Activity activity) {
        int REQUEST_EXTERNAL_STORAGE = 1;
        String[] PERMISSIONS_STORAGE = {
                "android.permission.READ_EXTERNAL_STORAGE",
                "android.permission.WRITE_EXTERNAL_STORAGE" };
        try {
            //检测是否有写的权限
            int permission = ActivityCompat.checkSelfPermission(activity,
                    "android.permission.WRITE_EXTERNAL_STORAGE");
            if (permission != PackageManager.PERMISSION_GRANTED) {
                // 没有写的权限，去申请写的权限，会弹出对话框
                ActivityCompat.requestPermissions(activity, PERMISSIONS_STORAGE,REQUEST_EXTERNAL_STORAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fix(View view) {

//        自动调用  1
//        so修复  资源
        File file = new File(Environment.getExternalStorageDirectory(), "out.dex");
        DexManager dexManager = new DexManager(this);
        dexManager.load(file);
    }
}
