package com.maniu.davidfix;

import android.content.Context;
import android.util.Log;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;

import dalvik.system.DexFile;

public class DexManager {
    private Context context;

    public DexManager(Context context) {
        this.context = context;
    }

    public void load(File file) {
        try {
            DexFile dexFile = DexFile.loadDex(file.getAbsolutePath(),
                    new File(context.getCacheDir(), "opt").getAbsolutePath(), Context.MODE_PRIVATE);
//
            Enumeration<String> entry = dexFile.entries();
            while (entry.hasMoreElements()) {
                String className = entry.nextElement();
                Class realClazz = dexFile.loadClass(className, context.getClassLoader());
                if (realClazz != null) {
                    fixClazz(realClazz);
                }

            }

        } catch (IOException e) {
            e.printStackTrace();
        }


    }

    private void fixClazz(Class realClazz) {


        try {
            Method[] methods = realClazz.getMethods();
            for (Method rightMethod : methods) {
                Replace replace=rightMethod.getAnnotation(Replace.class);
                if (replace == null) {
                    continue;
                }
                String clazzName = replace.clazz();
                String methodName = replace.method();
                Class wrongClazz = Class.forName(clazzName);
                Log.i("tuch", "fixClazz:====> "+rightMethod);
                Method wrongMethod = wrongClazz.getDeclaredMethod(methodName, rightMethod.getParameterTypes());
                replace(wrongMethod, rightMethod);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    public native static void replace(Method wrongMethod, Method rightMethod);

    // Used to load the 'native-lib' library on application startup.
    static {
        System.loadLibrary("native-lib");
    }
}