#!/usr/bin/perl -w

package KeyboardNames;

%models = (
    'A4Tech KB-21' => 'a4techKB21',
    'A4Tech KBS-8' => 'a4techKBS8',
    'A4Tech Wireless Desktop RFKB-23' => 'a4_rfkb23',
    'Acer AirKey V' => 'airkey',
    'Acer C300' => 'acer_c300',
    'Acer Ferrari 4000' => 'acer_ferrari4k',
    'Acer Laptop' => 'acer_laptop',
    'Advance Scorpius KI' => 'scorpius',
    'Amiga' => 'amiga',
    'Apple' => 'apple',
    'Apple Aluminium Keyboard (ANSI)' => 'applealu_ansi',
    'Apple Aluminium Keyboard (ISO)' => 'applealu_iso',
    'Apple Aluminium Keyboard (JIS)' => 'applealu_jis',
    'Apple Laptop' => 'apple_laptop',
    'Asus Laptop' => 'asus_laptop',
    'Atari TT' => 'ataritt',
    'Azona RF2300 wireless Internet Keyboard' => 'azonaRF2300',
    'BTC 5090' => 'btc5090',
    'BTC 5113RF Multimedia' => 'btc5113rf',
    'BTC 5126T' => 'btc5126t',
    'BTC 6301URF' => 'btc6301urf',
    'BTC 9000' => 'btc9000',
    'BTC 9000A' => 'btc9000a',
    'BTC 9001AH' => 'btc9001ah',
    'BTC 9019U' => 'btc9019u',
    'BTC 9116U Mini Wireless Internet and Gaming' => 'btc9116u',
    'BenQ X-Touch' => 'benqx',
    'BenQ X-Touch 730' => 'benqx730',
    'BenQ X-Touch 800' => 'benqx800',
    'Brother Internet Keyboard' => 'brother',
    'Cherry B.UNLIMITED' => 'cherrybunlim',
    'Cherry Blue Line CyBo@rd' => 'cherryblue',
    'Cherry Blue Line CyBo@rd (alternate option)' => 'cherrybluea',
    'Cherry CyBo@rd USB-Hub' => 'cherrycyboard',
    'Cherry CyMotion Expert' => 'cherrycmexpert',
    'Cherry CyMotion Master Linux' => 'cymotionlinux',
    'Cherry CyMotion Master XPress' => 'cherryblueb',
    'Chicony Internet Keyboard' => 'chicony',
    'Chicony KB-9885' => 'chicony9885',
    'Chicony KU-0108' => 'chicony0108',
    'Chicony KU-0420' => 'chicony0420',
    'Classmate PC' => 'classmate',
    'Compaq Easy Access Keyboard' => 'compaqeak8',
    'Compaq Internet Keyboard (13 keys)' => 'compaqik13',
    'Compaq Internet Keyboard (18 keys)' => 'compaqik18',
    'Compaq Internet Keyboard (7 keys)' => 'compaqik7',
    'Compaq iPaq Keyboard' => 'ipaq',
    'Creative Desktop Wireless 7000' => 'creativedw7000',
    'DTK2000' => 'dtk2000',
    'Dell' => 'dell',
    'Dell 101-key PC' => 'dell101',
    'Dell Laptop/notebook Inspiron 6xxx/8xxx' => 'inspiron',
    'Dell Laptop/notebook Precision M series' => 'precision_m',
    'Dell Latitude series laptop' => 'latitude',
    'Dell Precision M65' => 'dellm65',
    'Dell SK-8125' => 'dellsk8125',
    'Dell SK-8135' => 'dellsk8135',
    'Dell USB Multimedia Keyboard' => 'dellusbmm',
    'Dexxa Wireless Desktop Keyboard' => 'dexxa',
    'Diamond 9801 / 9802 series' => 'diamond',
    'Ennyah DKB-1008' => 'ennyah_dkb1008',
    'Everex STEPnote' => 'everex',
    'FL90' => 'compalfl90',
    'Fujitsu-Siemens Computers AMILO laptop' => 'fscaa1667g',
    'Generic 101-key PC' => 'pc101',
    'Generic 102-key (Intl) PC' => 'pc102',
    'Generic 104-key PC' => 'pc104',
    'Generic 105-key (Intl) PC' => 'pc105',
    'Genius Comfy KB-12e' => 'geniuscomfy',
    'Genius Comfy KB-16M / Genius MM Keyboard KWD-910' => 'genius',
    'Genius Comfy KB-21e-Scroll' => 'geniuscomfy2',
    'Genius KB-19e NB' => 'geniuskb19e',
    'Genius KKB-2050HS' => 'geniuskkb2050hs',
    'Gyration' => 'gyration',
    'HTC Dream' => 'htcdream',
    'Happy Hacking Keyboard' => 'hhk',
    'Happy Hacking Keyboard for Mac' => 'macintosh_hhk',
    'Hewlett-Packard Internet Keyboard' => 'hpi6',
    'Hewlett-Packard Mini 110 Notebook' => 'hpmini110',
    'Hewlett-Packard Omnibook 500 FA' => 'hp500fa',
    'Hewlett-Packard Omnibook 5xx' => 'hp5xx',
    'Hewlett-Packard Omnibook 6000/6100' => 'hp6000',
    'Hewlett-Packard Omnibook XE3 GC' => 'hpxe3gc',
    'Hewlett-Packard Omnibook XE3 GF' => 'hpxe3gf',
    'Hewlett-Packard Omnibook XT1000' => 'hpxt1000',
    'Hewlett-Packard Pavilion ZT11xx' => 'hpzt11xx',
    'Hewlett-Packard Pavilion dv5' => 'hpdv5',
    'Hewlett-Packard SK-250x Multimedia Keyboard' => 'hp250x',
    'Hewlett-Packard nx9020' => 'hpnx9020',
    'Honeywell Euroboard' => 'honeywell_euroboard',
    'Htc Dream phone' => 'htcdream',
    'IBM Rapid Access' => 'rapidaccess',
    'IBM Rapid Access II' => 'rapidaccess2',
    'IBM Space Saver' => 'ibm_spacesaver',
    'IBM ThinkPad 560Z/600/600E/A22E' => 'thinkpad',
    'IBM ThinkPad R60/T60/R61/T61' => 'thinkpad60',
    'IBM ThinkPad Z60m/Z60t/Z61m/Z61t' => 'thinkpadz60',
    'Keytronic FlexPro' => 'flexpro',
    'Kinesis' => 'kinesis',
    'Laptop/notebook Compaq (eg. Armada) Laptop Keyboard' => 'armada',
    'Laptop/notebook Compaq (eg. Presario) Internet Keyboard' => 'presario',
    'Laptop/notebook eMachines m68xx' => 'emachines',
    'Logitech Access Keyboard' => 'logiaccess',
    'Logitech Cordless Desktop' => 'logicd',
    'Logitech Cordless Desktop (alternate option)' => 'logicda',
    'Logitech Cordless Desktop EX110' => 'logiex110',
    'Logitech Cordless Desktop LX-300' => 'logiclx300',
    'Logitech Cordless Desktop Navigator' => 'logicdn',
    'Logitech Cordless Desktop Optical' => 'logicd_opt',
    'Logitech Cordless Desktop Pro (alternate option 2)' => 'logicdpa2',
    'Logitech Cordless Desktop iTouch' => 'logicd_it',
    'Logitech Cordless Freedom/Desktop Navigator' => 'logicfn',
    'Logitech G15 extra keys via G15daemon' => 'logitech_g15',
    'Logitech Generic Keyboard' => 'logitech_base',
    'Logitech Internet 350 Keyboard' => 'logii350',
    'Logitech Internet Keyboard' => 'logiik',
    'Logitech Internet Navigator Keyboard' => 'logicink',
    'Logitech Media Elite Keyboard' => 'logimel',
    'Logitech Ultra-X Cordless Media Desktop Keyboard' => 'logiultraxc',
    'Logitech Ultra-X Keyboard' => 'logiultrax',
    'Logitech diNovo Edge Keyboard' => 'logidinovoedge',
    'Logitech diNovo Keyboard' => 'logidinovo',
    'Logitech iTouch' => 'itouch',
    'Logitech iTouch Cordless Keyboard (model Y-RB6)' => 'logiitc',
    'Logitech iTouch Internet Navigator Keyboard SE' => 'logiinkse',
    'Logitech iTouch Internet Navigator Keyboard SE (USB)' => 'logiinkseusb',
    'MacBook/MacBook Pro' => 'macbook78',
    'MacBook/MacBook Pro (Intl)' => 'macbook79',
    'Macintosh' => 'macintosh',
    'Macintosh Old' => 'macintosh_old',
    'Memorex MX1998' => 'mx1998',
    'Memorex MX2500 EZ-Access Keyboard' => 'mx2500',
    'Memorex MX2750' => 'mx2750',
    'Microsoft Comfort Curve Keyboard 2000' => 'microsoftccurve2k',
    'Microsoft Internet Keyboard' => 'microsoftinet',
    'Microsoft Internet Keyboard Pro, Swedish' => 'microsoftprose',
    'Microsoft Natural' => 'microsoft',
    'Microsoft Natural Keyboard Elite' => 'microsoftelite',
    'Microsoft Natural Keyboard Pro / Microsoft Internet Keyboard Pro' => 'microsoftpro',
    'Microsoft Natural Keyboard Pro OEM' => 'microsoftprooem',
    'Microsoft Natural Keyboard Pro USB / Microsoft Internet Keyboard Pro' => 'microsoftprousb',
    'Microsoft Natural Wireless Ergonomic Keyboard 4000' => 'microsoft4000',
    'Microsoft Natural Wireless Ergonomic Keyboard 7000' => 'microsoft7000',
    'Microsoft Office Keyboard' => 'microsoftoffice',
    'Microsoft Wireless Multimedia Keyboard 1.0A' => 'microsoftmult',
    'Northgate OmniKey 101' => 'omnikey101',
    'OLPC' => 'olpc',
    'Ortek MCK-800 MM/Internet keyboard' => 'oretec',
    'PC-98xx Series' => 'pc98',
    'Propeller Voyager (KTEZ-1000)' => 'propeller',
    'QTronix Scorpius 98N+' => 'qtronix',
    'SILVERCREST Multimedia Wireless Keyboard' => 'silvercrest',
    'SK-1300' => 'sk1300',
    'SK-2500' => 'sk2500',
    'SK-6200' => 'sk6200',
    'SK-7100' => 'sk7100',
    'SVEN Ergonomic 2500' => 'sven',
    'SVEN Slim 303' => 'sven303',
    'Samsung SDM 4500P' => 'samsung4500',
    'Samsung SDM 4510P' => 'samsung4510',
    'Sanwa Supply SKB-KG3' => 'sanwaskbkg3',
    'Sun Type 4' => 'sun4',
    'Sun Type 5' => 'sun5',
    'Sun Type 6 (Japanese layout)' => 'sun_type6_jp',
    'Sun Type 6 USB (Japanese layout)' => 'sun_type6_jp_usb',
    'Sun Type 6 USB (Unix layout)' => 'sun_type6_unix_usb',
    'Sun Type 6/7 USB' => 'sun_type6_usb',
    'Sun Type 6/7 USB (European layout)' => 'sun_type6_euro_usb',
    'Sun Type 7 USB' => 'sun_type7_usb',
    'Sun Type 7 USB (European layout)' => 'sun_type7_euro_usb',
    'Sun Type 7 USB (Japanese layout) / Japanese 106-key' => 'sun_type7_jp_usb',
    'Sun Type 7 USB (Unix layout)' => 'sun_type7_unix_usb',
    'Super Power Multimedia Keyboard' => 'sp_inet',
    'Symplon PaceBook (tablet PC)' => 'symplon',
    'Targa Visionary 811' => 'targa_v811',
    'Toshiba Satellite S3000' => 'toshiba_s3000',
    'Trust Direct Access Keyboard' => 'trustda',
    'Trust Slimline' => 'trust_slimline',
    'Trust Wireless Keyboard Classic' => 'trust',
    'TypeMatrix EZ-Reach 2020' => 'tm2020',
    'TypeMatrix EZ-Reach 2030 PS2' => 'tm2030PS2',
    'TypeMatrix EZ-Reach 2030 USB' => 'tm2030USB',
    'TypeMatrix EZ-Reach 2030 USB (102/105:EU mode)' => 'tm2030USB-102',
    'TypeMatrix EZ-Reach 2030 USB (106:JP mode)' => 'tm2030USB-106',
    'Unitek KB-1925' => 'unitekkb1925',
    'ViewSonic KU-306 Internet Keyboard' => 'vsonku306',
    'Winbook Model XP5' => 'winbook',
    'Yahoo! Internet Keyboard' => 'yahoo',
);

%layouts = (
    'Afghani' => 'af',
    'Albanian' => 'al',
    'Amharic' => 'et',
    'Arabic' => 'ara',
    'Arabic (Morocco)' => 'ma',
    'Arabic (Syria)' => 'sy',
    'Armenian' => 'am',
    'Azerbaijani' => 'az',
    'Bambara' => 'ml',
    'Bangla' => 'bd',
    'Belarusian' => 'by',
    'Belgian' => 'be',
    'Bosnian' => 'ba',
    'Braille' => 'brai',
    'Bulgarian' => 'bg',
    'Burmese' => 'mm',
    'Chinese' => 'cn',
    'Croatian' => 'hr',
    'Czech' => 'cz',
    'Danish' => 'dk',
    'Dhivehi' => 'mv',
    'Dutch' => 'nl',
    'Dzongkha' => 'bt',
    'English (Cameroon)' => 'cm',
    'English (Ghana)' => 'gh',
    'English (Nigeria)' => 'ng',
    'English (South Africa)' => 'za',
    'English (UK)' => 'gb',
    'English (US)' => 'us',
    'Esperanto' => 'epo',
    'Estonian' => 'ee',
    'Faroese' => 'fo',
    'Filipino' => 'ph',
    'Finnish' => 'fi',
    'French' => 'fr',
    'French (Canada)' => 'ca',
    'French (Democratic Republic of the Congo)' => 'cd',
    'French (Guinea)' => 'gn',
    'Georgian' => 'ge',
    'German' => 'de',
    'German (Austria)' => 'at',
    'German (Switzerland)' => 'ch',
    'Greek' => 'gr',
    'Hebrew' => 'il',
    'Hungarian' => 'hu',
    'Icelandic' => 'is',
    'Indian' => 'in',
    'Iraqi' => 'iq',
    'Irish' => 'ie',
    'Italian' => 'it',
    'Japanese' => 'jp',
    'Japanese (PC-98xx Series)' => 'nec_vndr/jp',
    'Kazakh' => 'kz',
    'Khmer (Cambodia)' => 'kh',
    'Korean' => 'kr',
    'Kyrgyz' => 'kg',
    'Lao' => 'la',
    'Latvian' => 'lv',
    'Lithuanian' => 'lt',
    'Macedonian' => 'mk',
    'Maltese' => 'mt',
    'Maori' => 'mao',
    'Moldavian' => 'md',
    'Mongolian' => 'mn',
    'Montenegrin' => 'me',
    'Nepali' => 'np',
    'Norwegian' => 'no',
    'Persian' => 'ir',
    'Polish' => 'pl',
    'Portuguese' => 'pt',
    'Portuguese (Brazil)' => 'br',
    'Romanian' => 'ro',
    'Russian' => 'ru',
    'Serbian' => 'rs',
    'Sinhala (phonetic)' => 'lk',
    'Slovak' => 'sk',
    'Slovenian' => 'si',
    'Spanish' => 'es',
    'Spanish (Latin American)' => 'latam',
    'Swahili (Kenya)' => 'ke',
    'Swahili (Tanzania)' => 'tz',
    'Swedish' => 'se',
    'Taiwanese' => 'tw',
    'Tajik' => 'tj',
    'Thai' => 'th',
    'Tswana' => 'bw',
    'Turkish' => 'tr',
    'Turkmen' => 'tm',
    'Ukrainian' => 'ua',
    'Urdu (Pakistan)' => 'pk',
    'Uzbek' => 'uz',
    'Vietnamese' => 'vn',
    'Wolof' => 'sn',
);

%variants = (
    'af' => {
	'Pashto' => 'ps',
	'Pashto (Afghanistan, OLPC)' => 'olpc-ps',
	'Persian (Afghanistan, Dari OLPC)' => 'fa-olpc',
	'Uzbek (Afghanistan)' => 'uz',
	'Uzbek (Afghanistan, OLPC)' => 'uz-olpc',
    },
    'al' => {
	'Albanian (Plisi D1)' => 'plisi-d1',
    },
    'am' => {
	'Armenian (alternative eastern)' => 'eastern-alt',
	'Armenian (alternative phonetic)' => 'phonetic-alt',
	'Armenian (eastern)' => 'eastern',
	'Armenian (phonetic)' => 'phonetic',
	'Armenian (western)' => 'western',
    },
    'ara' => {
	'Arabic (Buckwalter)' => 'buckwalter',
	'Arabic (azerty)' => 'azerty',
	'Arabic (azerty/digits)' => 'azerty_digits',
	'Arabic (digits)' => 'digits',
	'Arabic (qwerty)' => 'qwerty',
	'Arabic (qwerty/digits)' => 'qwerty_digits',
    },
    'at' => {
	'German (Austria, Macintosh)' => 'mac',
	'German (Austria, Sun dead keys)' => 'sundeadkeys',
	'German (Austria, eliminate dead keys)' => 'nodeadkeys',
    },
    'az' => {
	'Azerbaijani (Cyrillic)' => 'cyrillic',
    },
    'ba' => {
	'Bosnian (US keyboard with Bosnian digraphs)' => 'unicodeus',
	'Bosnian (US keyboard with Bosnian letters)' => 'us',
	'Bosnian (with Bosnian digraphs)' => 'unicode',
	'Bosnian (with guillemets for quotes)' => 'alternatequotes',
    },
    'bd' => {
	'Bangla (Probhat)' => 'probhat',
    },
    'be' => {
	'Belgian (ISO alternate)' => 'iso-alternate',
	'Belgian (Sun dead keys)' => 'sundeadkeys',
	'Belgian (Wang model 724 azerty)' => 'wang',
	'Belgian (alternative)' => 'oss',
	'Belgian (alternative, Latin-9 only)' => 'oss_latin9',
	'Belgian (alternative, Sun dead keys)' => 'oss_sundeadkeys',
	'Belgian (eliminate dead keys)' => 'nodeadkeys',
    },
    'bg' => {
	'Bulgarian (new phonetic)' => 'bas_phonetic',
	'Bulgarian (traditional phonetic)' => 'phonetic',
    },
    'br' => {
	'Esperanto (Brazil, Nativo)' => 'nativo-epo',
	'Portuguese (Brazil, Dvorak)' => 'dvorak',
	'Portuguese (Brazil, Nativo for US keyboards)' => 'nativo-us',
	'Portuguese (Brazil, Nativo)' => 'nativo',
	'Portuguese (Brazil, eliminate dead keys)' => 'nodeadkeys',
    },
    'brai' => {
	'Braille (left hand)' => 'left_hand',
	'Braille (right hand)' => 'right_hand',
    },
    'by' => {
	'Belarusian (Latin)' => 'latin',
	'Belarusian (legacy)' => 'legacy',
    },
    'ca' => {
	'Canadian Multilingual' => 'multix',
	'Canadian Multilingual (first part)' => 'multi',
	'Canadian Multilingual (second part)' => 'multi-2gr',
	'English (Canada)' => 'eng',
	'French (Canada, Dvorak)' => 'fr-dvorak',
	'French (Canada, legacy)' => 'fr-legacy',
	'Inuktitut' => 'ike',
    },
    'ch' => {
	'French (Switzerland)' => 'fr',
	'French (Switzerland, Macintosh)' => 'fr_mac',
	'French (Switzerland, Sun dead keys)' => 'fr_sundeadkeys',
	'French (Switzerland, eliminate dead keys)' => 'fr_nodeadkeys',
	'German (Switzerland, Macintosh)' => 'de_mac',
	'German (Switzerland, Sun dead keys)' => 'de_sundeadkeys',
	'German (Switzerland, eliminate dead keys)' => 'de_nodeadkeys',
	'German (Switzerland, legacy)' => 'legacy',
    },
    'cm' => {
	'Cameroon Multilingual (Dvorak)' => 'dvorak',
	'Cameroon Multilingual (azerty)' => 'azerty',
	'Cameroon Multilingual (qwerty)' => 'qwerty',
	'French (Cameroon)' => 'french',
    },
    'cn' => {
	'Tibetan' => 'tib',
	'Tibetan (with ASCII numerals)' => 'tib_asciinum',
	'Uyghur' => 'ug',
    },
    'cz' => {
	'Czech (UCW layout, accented letters only)' => 'ucw',
	'Czech (US Dvorak with CZ UCW support)' => 'dvorak-ucw',
	'Czech (qwerty)' => 'qwerty',
	'Czech (qwerty, extended Backslash)' => 'qwerty_bksl',
	'Czech (with <\|> key)' => 'bksl',
    },
    'de' => {
	'German (Dvorak)' => 'dvorak',
	'German (Macintosh)' => 'mac',
	'German (Macintosh, eliminate dead keys)' => 'mac_nodeadkeys',
	'German (Neo 2)' => 'neo',
	'German (Sun dead keys)' => 'sundeadkeys',
	'German (T3)' => 'T3',
	'German (dead acute)' => 'deadacute',
	'German (dead grave acute)' => 'deadgraveacute',
	'German (eliminate dead keys)' => 'nodeadkeys',
	'German (legacy)' => 'legacy',
	'German (qwerty)' => 'qwerty',
	'Lower Sorbian' => 'dsb',
	'Lower Sorbian (qwertz)' => 'dsb_qwertz',
	'Romanian (Germany)' => 'ro',
	'Romanian (Germany, eliminate dead keys)' => 'ro_nodeadkeys',
	'Russian (Germany, phonetic)' => 'ru',
	'Turkish (Germany)' => 'tr',
    },
    'dk' => {
	'Danish (Dvorak)' => 'dvorak',
	'Danish (Macintosh)' => 'mac',
	'Danish (Macintosh, eliminate dead keys)' => 'mac_nodeadkeys',
	'Danish (Winkeys)' => 'winkeys',
	'Danish (eliminate dead keys)' => 'nodeadkeys',
    },
    'ee' => {
	'Estonian (Dvorak)' => 'dvorak',
	'Estonian (US keyboard with Estonian letters)' => 'us',
	'Estonian (eliminate dead keys)' => 'nodeadkeys',
    },
    'epo' => {
	'Esperanto (displaced semicolon and quote, obsolete)' => 'legacy',
    },
    'es' => {
	'Asturian (Spain, with bottom-dot H and bottom-dot L)' => 'ast',
	'Catalan (Spain, with middle-dot L)' => 'cat',
	'Spanish (Dvorak)' => 'dvorak',
	'Spanish (Macintosh)' => 'mac',
	'Spanish (Sun dead keys)' => 'sundeadkeys',
	'Spanish (Winkeys)' => 'winkeys',
	'Spanish (eliminate dead keys)' => 'nodeadkeys',
	'Spanish (include dead tilde)' => 'deadtilde',
    },
    'fi' => {
	'Finnish (Macintosh)' => 'mac',
	'Finnish (Winkeys)' => 'winkeys',
	'Finnish (classic)' => 'classic',
	'Finnish (classic, eliminate dead keys)' => 'nodeadkeys',
	'Northern Saami (Finland)' => 'smi',
    },
    'fo' => {
	'Faroese (eliminate dead keys)' => 'nodeadkeys',
    },
    'fr' => {
	'French (Bepo, ergonomic, Dvorak way)' => 'bepo',
	'French (Bepo, ergonomic, Dvorak way, Latin-9 only)' => 'bepo_latin9',
	'French (Breton)' => 'bre',
	'French (Dvorak)' => 'dvorak',
	'French (Macintosh)' => 'mac',
	'French (Sun dead keys)' => 'sundeadkeys',
	'French (alternative)' => 'oss',
	'French (alternative, Latin-9 only)' => 'oss_latin9',
	'French (alternative, Sun dead keys)' => 'oss_sundeadkeys',
	'French (alternative, eliminate dead keys)' => 'oss_nodeadkeys',
	'French (eliminate dead keys)' => 'nodeadkeys',
	'French (legacy, alternative)' => 'latin9',
	'French (legacy, alternative, Sun dead keys)' => 'latin9_sundeadkeys',
	'French (legacy, alternative, eliminate dead keys)' => 'latin9_nodeadkeys',
	'Georgian (France, AZERTY Tskapo)' => 'geo',
	'Occitan' => 'oci',
    },
    'gb' => {
	'English (UK, Colemak)' => 'colemak',
	'English (UK, Dvorak with UK punctuation)' => 'dvorakukp',
	'English (UK, Dvorak)' => 'dvorak',
	'English (UK, Macintosh international)' => 'mac_intl',
	'English (UK, Macintosh)' => 'mac',
	'English (UK, extended WinKeys)' => 'extd',
	'English (UK, international with dead keys)' => 'intl',
    },
    'ge' => {
	'Georgian (MESS)' => 'mess',
	'Georgian (ergonomic)' => 'ergonomic',
	'Ossetian (Georgia)' => 'os',
	'Russian (Georgia)' => 'ru',
    },
    'gh' => {
	'Akan' => 'akan',
	'Avatime' => 'avn',
	'English (Ghana, GILLBT)' => 'gillbt',
	'English (Ghana, multilingual)' => 'generic',
	'Ewe' => 'ewe',
	'Fula' => 'fula',
	'Ga' => 'ga',
	'Hausa' => 'hausa',
    },
    'gr' => {
	'Greek (eliminate dead keys)' => 'nodeadkeys',
	'Greek (extended)' => 'extended',
	'Greek (polytonic)' => 'polytonic',
	'Greek (simple)' => 'simple',
    },
    'hr' => {
	'Croatian (US keyboard with Croatian digraphs)' => 'unicodeus',
	'Croatian (US keyboard with Croatian letters)' => 'us',
	'Croatian (with Croatian digraphs)' => 'unicode',
	'Croatian (with guillemets for quotes)' => 'alternatequotes',
    },
    'hu' => {
	'Hungarian (101/qwerty/comma/dead keys)' => '101_qwerty_comma_dead',
	'Hungarian (101/qwerty/comma/eliminate dead keys)' => '101_qwerty_comma_nodead',
	'Hungarian (101/qwerty/dot/dead keys)' => '101_qwerty_dot_dead',
	'Hungarian (101/qwerty/dot/eliminate dead keys)' => '101_qwerty_dot_nodead',
	'Hungarian (101/qwertz/comma/dead keys)' => '101_qwertz_comma_dead',
	'Hungarian (101/qwertz/comma/eliminate dead keys)' => '101_qwertz_comma_nodead',
	'Hungarian (101/qwertz/dot/dead keys)' => '101_qwertz_dot_dead',
	'Hungarian (101/qwertz/dot/eliminate dead keys)' => '101_qwertz_dot_nodead',
	'Hungarian (102/qwerty/comma/dead keys)' => '102_qwerty_comma_dead',
	'Hungarian (102/qwerty/comma/eliminate dead keys)' => '102_qwerty_comma_nodead',
	'Hungarian (102/qwerty/dot/dead keys)' => '102_qwerty_dot_dead',
	'Hungarian (102/qwerty/dot/eliminate dead keys)' => '102_qwerty_dot_nodead',
	'Hungarian (102/qwertz/comma/dead keys)' => '102_qwertz_comma_dead',
	'Hungarian (102/qwertz/comma/eliminate dead keys)' => '102_qwertz_comma_nodead',
	'Hungarian (102/qwertz/dot/dead keys)' => '102_qwertz_dot_dead',
	'Hungarian (102/qwertz/dot/eliminate dead keys)' => '102_qwertz_dot_nodead',
	'Hungarian (eliminate dead keys)' => 'nodeadkeys',
	'Hungarian (qwerty)' => 'qwerty',
	'Hungarian (standard)' => 'standard',
    },
    'ie' => {
	'CloGaelach' => 'CloGaelach',
	'Irish (UnicodeExpert)' => 'UnicodeExpert',
	'Ogham' => 'ogam',
	'Ogham (IS434)' => 'ogam_is434',
    },
    'il' => {
	'Hebrew (Biblical, Tiro)' => 'biblical',
	'Hebrew (lyx)' => 'lyx',
	'Hebrew (phonetic)' => 'phonetic',
    },
    'in' => {
	'Bangla (India)' => 'ben',
	'Bangla (India, Baishakhi Inscript)' => 'ben_inscript',
	'Bangla (India, Baishakhi)' => 'ben_baishakhi',
	'Bangla (India, Bornona)' => 'ben_bornona',
	'Bangla (India, Probhat)' => 'ben_probhat',
	'Bangla (India, Uni Gitanjali)' => 'ben_gitanjali',
	'English (India, with rupee sign)' => 'eng',
	'Gujarati' => 'guj',
	'Hindi (Bolnagri)' => 'bolnagri',
	'Hindi (KaGaPa phonetic)' => 'hin-kagapa',
	'Hindi (Wx)' => 'hin-wx',
	'Kannada' => 'kan',
	'Kannada (KaGaPa phonetic)' => 'kan-kagapa',
	'Malayalam' => 'mal',
	'Malayalam (Lalitha)' => 'mal_lalitha',
	'Malayalam (enhanced Inscript, with rupee sign)' => 'mal_enhanced',
	'Manipuri (Eeyek)' => 'eeyek',
	'Marathi (KaGaPa phonetic)' => 'mar-kagapa',
	'Oriya' => 'ori',
	'Punjabi (Gurmukhi Jhelum)' => 'jhelum',
	'Punjabi (Gurmukhi)' => 'guru',
	'Sanskrit (KaGaPa phonetic)' => 'san-kagapa',
	'Tamil' => 'tam',
	'Tamil (TAB typewriter)' => 'tam_TAB',
	'Tamil (TSCII typewriter)' => 'tam_TSCII',
	'Tamil (Unicode)' => 'tam_unicode',
	'Tamil (keyboard with numerals)' => 'tam_keyboard_with_numerals',
	'Telugu' => 'tel',
	'Telugu (KaGaPa phonetic)' => 'tel-kagapa',
	'Urdu (WinKeys)' => 'urd-winkeys',
	'Urdu (alternative phonetic)' => 'urd-phonetic3',
	'Urdu (phonetic)' => 'urd-phonetic',
    },
    'iq' => {
	'Kurdish (Iraq, Arabic-Latin)' => 'ku_ara',
	'Kurdish (Iraq, F)' => 'ku_f',
	'Kurdish (Iraq, Latin Alt-Q)' => 'ku_alt',
	'Kurdish (Iraq, Latin Q)' => 'ku',
    },
    'ir' => {
	'Kurdish (Iran, Arabic-Latin)' => 'ku_ara',
	'Kurdish (Iran, F)' => 'ku_f',
	'Kurdish (Iran, Latin Alt-Q)' => 'ku_alt',
	'Kurdish (Iran, Latin Q)' => 'ku',
	'Persian (with Persian keypad)' => 'pes_keypad',
    },
    'is' => {
	'Icelandic (Dvorak)' => 'dvorak',
	'Icelandic (Macintosh)' => 'mac',
	'Icelandic (Sun dead keys)' => 'Sundeadkeys',
	'Icelandic (eliminate dead keys)' => 'nodeadkeys',
    },
    'it' => {
	'Georgian (Italy)' => 'geo',
	'Italian (IBM 142)' => 'ibm',
	'Italian (Macintosh)' => 'mac',
	'Italian (US keyboard with Italian letters)' => 'us',
	'Italian (Winkeys)' => 'winkeys',
	'Italian (eliminate dead keys)' => 'nodeadkeys',
    },
    'jp' => {
	'Japanese (Dvorak)' => 'dvorak',
	'Japanese (Kana 86)' => 'kana86',
	'Japanese (Kana)' => 'kana',
	'Japanese (Macintosh)' => 'mac',
	'Japanese (OADG 109A)' => 'OADG109A',
    },
    'ke' => {
	'Kikuyu' => 'kik',
    },
    'kg' => {
	'Kyrgyz (phonetic)' => 'phonetic',
    },
    'kr' => {
	'Korean (101/104 key compatible)' => 'kr104',
    },
    'kz' => {
	'Kazakh (with Russian)' => 'kazrus',
	'Russian (Kazakhstan, with Kazakh)' => 'ruskaz',
    },
    'la' => {
	'Lao (STEA proposed standard layout)' => 'stea',
    },
    'latam' => {
	'Spanish (Latin American, Sun dead keys)' => 'sundeadkeys',
	'Spanish (Latin American, eliminate dead keys)' => 'nodeadkeys',
	'Spanish (Latin American, include dead tilde)' => 'deadtilde',
    },
    'lk' => {
	'Tamil (Sri Lanka, TAB Typewriter)' => 'tam_TAB',
	'Tamil (Sri Lanka, Unicode)' => 'tam_unicode',
    },
    'lt' => {
	'Lithuanian (IBM LST 1205-92)' => 'ibm',
	'Lithuanian (LEKP)' => 'lekp',
	'Lithuanian (LEKPa)' => 'lekpa',
	'Lithuanian (US keyboard with Lithuanian letters)' => 'us',
	'Lithuanian (standard)' => 'std',
    },
    'lv' => {
	'Latvian (F variant)' => 'fkey',
	'Latvian (adapted)' => 'adapted',
	'Latvian (apostrophe variant)' => 'apostrophe',
	'Latvian (ergonomic, ŪGJRMV)' => 'ergonomic',
	'Latvian (modern)' => 'modern',
	'Latvian (tilde variant)' => 'tilde',
    },
    'ma' => {
	'Berber (Morocco, Tifinagh alternative phonetic)' => 'tifinagh-alt-phonetic',
	'Berber (Morocco, Tifinagh alternative)' => 'tifinagh-alt',
	'Berber (Morocco, Tifinagh extended phonetic)' => 'tifinagh-extended-phonetic',
	'Berber (Morocco, Tifinagh extended)' => 'tifinagh-extended',
	'Berber (Morocco, Tifinagh phonetic)' => 'tifinagh-phonetic',
	'Berber (Morocco, Tifinagh)' => 'tifinagh',
	'French (Morocco)' => 'french',
    },
    'md' => {
	'Moldavian (Gagauz)' => 'gag',
    },
    'me' => {
	'Montenegrin (Cyrillic with guillemets)' => 'cyrillicalternatequotes',
	'Montenegrin (Cyrillic)' => 'cyrillic',
	'Montenegrin (Cyrillic, ZE and ZHE swapped)' => 'cyrillicyz',
	'Montenegrin (Latin Unicode qwerty)' => 'latinunicodeyz',
	'Montenegrin (Latin Unicode)' => 'latinunicode',
	'Montenegrin (Latin qwerty)' => 'latinyz',
	'Montenegrin (Latin with guillemets)' => 'latinalternatequotes',
    },
    'mk' => {
	'Macedonian (eliminate dead keys)' => 'nodeadkeys',
    },
    'ml' => {
	'English (Mali, US Macintosh)' => 'us-mac',
	'English (Mali, US international)' => 'us-intl',
	'French (Mali, alternative)' => 'fr-oss',
    },
    'mt' => {
	'Maltese (with US layout)' => 'us',
    },
    'ng' => {
	'Hausa' => 'hausa',
	'Igbo' => 'igbo',
	'Yoruba' => 'yoruba',
    },
    'nl' => {
	'Dutch (Macintosh)' => 'mac',
	'Dutch (Sun dead keys)' => 'sundeadkeys',
	'Dutch (standard)' => 'std',
    },
    'no' => {
	'Northern Saami (Norway)' => 'smi',
	'Northern Saami (Norway, eliminate dead keys)' => 'smi_nodeadkeys',
	'Norwegian (Colemak)' => 'colemak',
	'Norwegian (Dvorak)' => 'dvorak',
	'Norwegian (Macintosh)' => 'mac',
	'Norwegian (Macintosh, eliminate dead keys)' => 'mac_nodeadkeys',
	'Norwegian (Winkeys)' => 'winkeys',
	'Norwegian (eliminate dead keys)' => 'nodeadkeys',
    },
    'ph' => {
	'Filipino (Capewell-Dvorak Baybayin)' => 'capewell-dvorak-bay',
	'Filipino (Capewell-Dvorak Latin)' => 'capewell-dvorak',
	'Filipino (Capewell-QWERF 2006 Baybayin)' => 'capewell-qwerf2k6-bay',
	'Filipino (Capewell-QWERF 2006 Latin)' => 'capewell-qwerf2k6',
	'Filipino (Colemak Baybayin)' => 'colemak-bay',
	'Filipino (Colemak Latin)' => 'colemak',
	'Filipino (Dvorak Baybayin)' => 'dvorak-bay',
	'Filipino (Dvorak Latin)' => 'dvorak',
	'Filipino (QWERTY Baybayin)' => 'qwerty-bay',
    },
    'pk' => {
	'Arabic (Pakistan)' => 'ara',
	'Sindhi' => 'snd',
	'Urdu (Pakistan, CRULP)' => 'urd-crulp',
	'Urdu (Pakistan, NLA)' => 'urd-nla',
    },
    'pl' => {
	'Kashubian' => 'csb',
	'Polish (Dvorak)' => 'dvorak',
	'Polish (Dvorak, Polish quotes on key 1)' => 'dvorak_altquotes',
	'Polish (Dvorak, Polish quotes on quotemark key)' => 'dvorak_quotes',
	'Polish (legacy)' => 'legacy',
	'Polish (programmer Dvorak)' => 'dvp',
	'Polish (qwertz)' => 'qwertz',
	'Russian (Poland, phonetic Dvorak)' => 'ru_phonetic_dvorak',
	'Silesian' => 'szl',
    },
    'pt' => {
	'Esperanto (Portugal, Nativo)' => 'nativo-epo',
	'Portuguese (Macintosh)' => 'mac',
	'Portuguese (Macintosh, Sun dead keys)' => 'mac_sundeadkeys',
	'Portuguese (Macintosh, eliminate dead keys)' => 'mac_nodeadkeys',
	'Portuguese (Nativo for US keyboards)' => 'nativo-us',
	'Portuguese (Nativo)' => 'nativo',
	'Portuguese (Sun dead keys)' => 'sundeadkeys',
	'Portuguese (eliminate dead keys)' => 'nodeadkeys',
    },
    'ro' => {
	'Romanian (WinKeys)' => 'winkeys',
	'Romanian (cedilla)' => 'cedilla',
	'Romanian (standard cedilla)' => 'std_cedilla',
	'Romanian (standard)' => 'std',
    },
    'rs' => {
	'Pannonian Rusyn' => 'rue',
	'Serbian (Cyrillic with guillemets)' => 'alternatequotes',
	'Serbian (Cyrillic, ZE and ZHE swapped)' => 'yz',
	'Serbian (Latin Unicode qwerty)' => 'latinunicodeyz',
	'Serbian (Latin Unicode)' => 'latinunicode',
	'Serbian (Latin qwerty)' => 'latinyz',
	'Serbian (Latin with guillemets)' => 'latinalternatequotes',
	'Serbian (Latin)' => 'latin',
    },
    'ru' => {
	'Bashkirian' => 'bak',
	'Chuvash' => 'cv',
	'Chuvash (Latin)' => 'cv_latin',
	'Kalmyk' => 'xal',
	'Komi' => 'kom',
	'Mari' => 'chm',
	'Ossetian (WinKeys)' => 'os_winkeys',
	'Ossetian (legacy)' => 'os_legacy',
	'Russian (DOS)' => 'dos',
	'Russian (Macintosh)' => 'mac',
	'Russian (legacy)' => 'legacy',
	'Russian (phonetic WinKeys)' => 'phonetic_winkeys',
	'Russian (phonetic)' => 'phonetic',
	'Russian (typewriter)' => 'typewriter',
	'Russian (typewriter, legacy)' => 'typewriter-legacy',
	'Serbian (Russia)' => 'srp',
	'Tatar' => 'tt',
	'Udmurt' => 'udm',
	'Yakut' => 'sah',
    },
    'se' => {
	'Northern Saami (Sweden)' => 'smi',
	'Russian (Sweden, phonetic)' => 'rus',
	'Russian (Sweden, phonetic, eliminate dead keys)' => 'rus_nodeadkeys',
	'Swedish (Dvorak)' => 'dvorak',
	'Swedish (Macintosh)' => 'mac',
	'Swedish (Svdvorak)' => 'svdvorak',
	'Swedish (eliminate dead keys)' => 'nodeadkeys',
	'Swedish Sign Language' => 'swl',
    },
    'si' => {
	'Slovenian (US keyboard with Slovenian letters)' => 'us',
	'Slovenian (with guillemets for quotes)' => 'alternatequotes',
    },
    'sk' => {
	'Slovak (extended Backslash)' => 'bksl',
	'Slovak (qwerty)' => 'qwerty',
	'Slovak (qwerty, extended Backslash)' => 'qwerty_bksl',
    },
    'sy' => {
	'Kurdish (Syria, F)' => 'ku_f',
	'Kurdish (Syria, Latin Alt-Q)' => 'ku_alt',
	'Kurdish (Syria, Latin Q)' => 'ku',
	'Syriac' => 'syc',
	'Syriac (phonetic)' => 'syc_phonetic',
    },
    'th' => {
	'Thai (Pattachote)' => 'pat',
	'Thai (TIS-820.2538)' => 'tis',
    },
    'tj' => {
	'Tajik (legacy)' => 'legacy',
    },
    'tm' => {
	'Turkmen (Alt-Q)' => 'alt',
    },
    'tr' => {
	'Crimean Tatar (Turkish Alt-Q)' => 'crh_alt',
	'Crimean Tatar (Turkish F)' => 'crh_f',
	'Crimean Tatar (Turkish Q)' => 'crh',
	'Kurdish (Turkey, F)' => 'ku_f',
	'Kurdish (Turkey, Latin Alt-Q)' => 'ku_alt',
	'Kurdish (Turkey, Latin Q)' => 'ku',
	'Turkish (Alt-Q)' => 'alt',
	'Turkish (F)' => 'f',
	'Turkish (Sun dead keys)' => 'sundeadkeys',
	'Turkish (international with dead keys)' => 'intl',
    },
    'tw' => {
	'Saisiyat (Taiwan)' => 'saisiyat',
	'Taiwanese (indigenous)' => 'indigenous',
    },
    'ua' => {
	'Russian (Ukraine, standard RSTU)' => 'rstu_ru',
	'Ukrainian (WinKeys)' => 'winkeys',
	'Ukrainian (homophonic)' => 'homophonic',
	'Ukrainian (legacy)' => 'legacy',
	'Ukrainian (phonetic)' => 'phonetic',
	'Ukrainian (standard RSTU)' => 'rstu',
	'Ukrainian (typewriter)' => 'typewriter',
    },
    'us' => {
	'Cherokee' => 'chr',
	'English (Colemak)' => 'colemak',
	'English (Dvorak alternative international no dead keys)' => 'dvorak-alt-intl',
	'English (Dvorak)' => 'dvorak',
	'English (Dvorak, international with dead keys)' => 'dvorak-intl',
	'English (Macintosh)' => 'mac',
	'English (US, alternative international)' => 'alt-intl',
	'English (US, international with dead keys)' => 'intl',
	'English (US, with euro on 5)' => 'euro',
	'English (Workman)' => 'workman',
	'English (Workman, international with dead keys)' => 'workman-intl',
	'English (classic Dvorak)' => 'dvorak-classic',
	'English (international AltGr dead keys)' => 'altgr-intl',
	'English (left handed Dvorak)' => 'dvorak-l',
	'English (programmer Dvorak)' => 'dvp',
	'English (right handed Dvorak)' => 'dvorak-r',
	'English (the divide/multiply keys toggle the layout)' => 'olpc2',
	'Russian (US, phonetic)' => 'rus',
	'Serbo-Croatian (US)' => 'hbs',
    },
    'uz' => {
	'Uzbek (Latin)' => 'latin',
    },
);

1;
