# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.





from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_pyupm_sm130', [dirname(__file__)])
        except ImportError:
            import _pyupm_sm130
            return _pyupm_sm130
        if fp is not None:
            try:
                _mod = imp.load_module('_pyupm_sm130', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _pyupm_sm130 = swig_import_helper()
    del swig_import_helper
else:
    import _pyupm_sm130
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


SM130_DEFAULT_UART = _pyupm_sm130.SM130_DEFAULT_UART
SM130_DEFAULT_RESET_PIN = _pyupm_sm130.SM130_DEFAULT_RESET_PIN
class SM130(_object):
    """
    API for the SM130 RFID Reader Module.

    ID: sm130

    Name: SM130 RFID Reader

    Category: rfid

    Manufacturer: sparkfun

    Link:https://www.sparkfun.com/products/10126

    Connection: uart gpio  This module defines the SM130 interface for the
    sm130 RFID library

    This module was developed using an SM130 and a Sparkfun RFID
    Evaluation shield using a UART for communications. It should be fairly
    trivial to add support for I2C communication in the future, if you
    have the correct firmware on the SM130.

    SM130 RFID Reader image provided by SparkFun* underCC BY-NC-SA-3.0.

    C++ includes: sm130.h 
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SM130, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SM130, name)
    __repr__ = _swig_repr
    CMD_RESET = _pyupm_sm130.SM130_CMD_RESET
    CMD_VERSION = _pyupm_sm130.SM130_CMD_VERSION
    CMD_SEEK_TAG = _pyupm_sm130.SM130_CMD_SEEK_TAG
    CMD_SELECT_TAG = _pyupm_sm130.SM130_CMD_SELECT_TAG
    CMD_AUTHENTICATE = _pyupm_sm130.SM130_CMD_AUTHENTICATE
    CMD_READ16 = _pyupm_sm130.SM130_CMD_READ16
    CMD_READ_VALUE = _pyupm_sm130.SM130_CMD_READ_VALUE
    CMD_WRITE16 = _pyupm_sm130.SM130_CMD_WRITE16
    CMD_WRITE_VALUE = _pyupm_sm130.SM130_CMD_WRITE_VALUE
    CMD_WRITE4 = _pyupm_sm130.SM130_CMD_WRITE4
    CMD_WRITE_KEY = _pyupm_sm130.SM130_CMD_WRITE_KEY
    CMD_INC_VALUE = _pyupm_sm130.SM130_CMD_INC_VALUE
    CMD_DEC_VALUE = _pyupm_sm130.SM130_CMD_DEC_VALUE
    CMD_ANTENNA_POWER = _pyupm_sm130.SM130_CMD_ANTENNA_POWER
    CMD_READ_PORT = _pyupm_sm130.SM130_CMD_READ_PORT
    CMD_WRITE_PORT = _pyupm_sm130.SM130_CMD_WRITE_PORT
    CMD_HALT_TAG = _pyupm_sm130.SM130_CMD_HALT_TAG
    CMD_SET_BAUD = _pyupm_sm130.SM130_CMD_SET_BAUD
    CMD_SLEEP = _pyupm_sm130.SM130_CMD_SLEEP
    TAG_NONE = _pyupm_sm130.SM130_TAG_NONE
    TAG_MIFARE_ULTRALIGHT = _pyupm_sm130.SM130_TAG_MIFARE_ULTRALIGHT
    TAG_MIFARE_1K = _pyupm_sm130.SM130_TAG_MIFARE_1K
    TAG_MIFARE_4K = _pyupm_sm130.SM130_TAG_MIFARE_4K
    TAG_UNKNOWN = _pyupm_sm130.SM130_TAG_UNKNOWN
    KEY_TYPE_EEPROM_A0 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A0
    KEY_TYPE_EEPROM_A1 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A1
    KEY_TYPE_EEPROM_A2 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A2
    KEY_TYPE_EEPROM_A3 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A3
    KEY_TYPE_EEPROM_A4 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A4
    KEY_TYPE_EEPROM_A5 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A5
    KEY_TYPE_EEPROM_A6 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A6
    KEY_TYPE_EEPROM_A7 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A7
    KEY_TYPE_EEPROM_A8 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A8
    KEY_TYPE_EEPROM_A9 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A9
    KEY_TYPE_EEPROM_A10 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A10
    KEY_TYPE_EEPROM_A11 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A11
    KEY_TYPE_EEPROM_A12 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A12
    KEY_TYPE_EEPROM_A13 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A13
    KEY_TYPE_EEPROM_A14 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A14
    KEY_TYPE_EEPROM_A15 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_A15
    KEY_TYPE_EEPROM_B0 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B0
    KEY_TYPE_EEPROM_B1 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B1
    KEY_TYPE_EEPROM_B2 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B2
    KEY_TYPE_EEPROM_B3 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B3
    KEY_TYPE_EEPROM_B4 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B4
    KEY_TYPE_EEPROM_B5 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B5
    KEY_TYPE_EEPROM_B6 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B6
    KEY_TYPE_EEPROM_B7 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B7
    KEY_TYPE_EEPROM_B8 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B8
    KEY_TYPE_EEPROM_B9 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B9
    KEY_TYPE_EEPROM_B10 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B10
    KEY_TYPE_EEPROM_B11 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B11
    KEY_TYPE_EEPROM_B12 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B12
    KEY_TYPE_EEPROM_B13 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B13
    KEY_TYPE_EEPROM_B14 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B14
    KEY_TYPE_EEPROM_B15 = _pyupm_sm130.SM130_KEY_TYPE_EEPROM_B15
    KEY_TYPE_A = _pyupm_sm130.SM130_KEY_TYPE_A
    KEY_TYPE_B = _pyupm_sm130.SM130_KEY_TYPE_B
    KEY_TYPE_A_AND_TRANSPORT_F = _pyupm_sm130.SM130_KEY_TYPE_A_AND_TRANSPORT_F
    def __init__(self, uart=0, reset=13): 
        """
        __init__(upm::SM130 self, int uart=0, int reset=13) -> SM130

        Parameters:
            uart: int
            reset: int

        __init__(upm::SM130 self, int uart=0) -> SM130

        Parameters:
            uart: int

        __init__(upm::SM130 self) -> SM130

        SM130(int
        uart=SM130_DEFAULT_UART, int reset=SM130_DEFAULT_RESET_PIN)

        Instantiates an SM130 object

        Parameters:
        -----------

        uart:  The UART port. Default is 0.

        reset:  The Reset pin. Default is 13. 
        """
        this = _pyupm_sm130.new_SM130(uart, reset)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _pyupm_sm130.delete_SM130
    __del__ = lambda self : None;
    def setBaudRate(self, baud=19200):
        """
        setBaudRate(SM130 self, int baud=19200) -> mraa::Result

        Parameters:
            baud: int

        setBaudRate(SM130 self) -> mraa::Result

        Parameters:
            self: upm::SM130 *


        mraa::Result
        setBaudRate(int baud=19200)

        Sets the baud rate for the device. The default is 19200.

        Parameters:
        -----------

        baud:  Desired baud rate, default 19200

        mraa::Result value 
        """
        return _pyupm_sm130.SM130_setBaudRate(self, baud)

    def getFirmwareVersion(self):
        """
        getFirmwareVersion(SM130 self) -> std::string

        Parameters:
            self: upm::SM130 *


        string
        getFirmwareVersion()

        Gets the firmware version string.

        The firmware revision 
        """
        return _pyupm_sm130.SM130_getFirmwareVersion(self)

    def reset(self):
        """
        reset(SM130 self) -> bool

        Parameters:
            self: upm::SM130 *


        bool reset()

        Issues a reset command to the device.

        true if successful 
        """
        return _pyupm_sm130.SM130_reset(self)

    def hardwareReset(self):
        """
        hardwareReset(SM130 self)

        Parameters:
            self: upm::SM130 *


        void
        hardwareReset()

        Resets the device using the hardware RESET pin. This is required if
        the device has been put to sleep using the sleep() method. 
        """
        return _pyupm_sm130.SM130_hardwareReset(self)

    def select(self):
        """
        select(SM130 self) -> bool

        Parameters:
            self: upm::SM130 *


        bool select()

        Checks to see if a tag is in the RF field, and selects it if one is
        present.

        true if a tag was detected, false if no tag is present or an error was
        detected. 
        """
        return _pyupm_sm130.SM130_select(self)

    def waitForTag(self, *args):
        """
        waitForTag(SM130 self, uint32_t timeout) -> bool

        Parameters:
            timeout: uint32_t


        bool
        waitForTag(uint32_t timeout)

        Waits for a tag to enter the RF field for up to 'timeout'
        milliseconds. It will call select() every 100ms until 'timeout' has
        been exceeded.

        Parameters:
        -----------

        timeout:  The number of milliseconds to wait for a tag to appear

        true if a tag was detected, false if no tag was detected within the
        timeout value, or an error occurred 
        """
        return _pyupm_sm130.SM130_waitForTag(self, *args)

    def authenticate(self, *args):
        """
        authenticate(SM130 self, uint8_t block, upm::SM130::KEY_TYPES_T keyType, std::string key="") -> bool

        Parameters:
            block: uint8_t
            keyType: enum upm::SM130::KEY_TYPES_T
            key: std::string

        authenticate(SM130 self, uint8_t block, upm::SM130::KEY_TYPES_T keyType) -> bool

        Parameters:
            block: uint8_t
            keyType: enum upm::SM130::KEY_TYPES_T


        bool
        authenticate(uint8_t block, KEY_TYPES_T keyType, std::string key="")

        Set the authentication key for a block. Depending on the permissions
        on the tag, the correct key must be authenticated for that block in
        order to perform read and write operations.

        Parameters:
        -----------

        block:  The block to authenticate for

        keyType:  one of the KEY_TYPE_T values

        key:  The 6 byte key to use for Type A and Type B keys

        true if authentication was successful, false otherwise 
        """
        return _pyupm_sm130.SM130_authenticate(self, *args)

    def readBlock16(self, *args):
        """
        readBlock16(SM130 self, uint8_t block) -> std::string

        Parameters:
            block: uint8_t


        string
        readBlock16(uint8_t block)

        Read a 16 byte block. Depending on the tag, authentication of the
        block may be required for this method to succeed.

        Parameters:
        -----------

        block:  The block to read

        The 16 byte block if successful, an empty string otherwise 
        """
        return _pyupm_sm130.SM130_readBlock16(self, *args)

    def readValueBlock(self, *args):
        """
        readValueBlock(SM130 self, uint8_t block) -> int32_t

        Parameters:
            block: uint8_t


        int32_t
        readValueBlock(uint8_t block)

        Read a 4 byte value block. Depending on the tag, authentication of the
        block may be required for this method to succeed.

        Parameters:
        -----------

        block:  The block to read

        The 4 byte signed integer value block if successful, 0 otherwise 
        """
        return _pyupm_sm130.SM130_readValueBlock(self, *args)

    def writeBlock16(self, *args):
        """
        writeBlock16(SM130 self, uint8_t block, std::string contents) -> bool

        Parameters:
            block: uint8_t
            contents: std::string


        bool
        writeBlock16(uint8_t block, std::string contents)

        Write 16 bytes to a block. Depending on the tag, authentication of the
        block may be required for this method to succeed.

        Parameters:
        -----------

        block:  The block to write

        contents:  A 16 byte string containing the data to write

        true if successful, false otherwise 
        """
        return _pyupm_sm130.SM130_writeBlock16(self, *args)

    def writeValueBlock(self, *args):
        """
        writeValueBlock(SM130 self, uint8_t block, int32_t value) -> bool

        Parameters:
            block: uint8_t
            value: int32_t


        bool
        writeValueBlock(uint8_t block, int32_t value)

        Write to a 4 byte value block. Depending on the tag, authentication of
        the block may be required for this method to succeed.

        Parameters:
        -----------

        block:  The block to write

        value:  the signed 4 byte integer to write to the value block

        true if successful, false otherwise 
        """
        return _pyupm_sm130.SM130_writeValueBlock(self, *args)

    def writeBlock4(self, *args):
        """
        writeBlock4(SM130 self, uint8_t block, std::string contents) -> bool

        Parameters:
            block: uint8_t
            contents: std::string


        bool
        writeBlock4(uint8_t block, std::string contents)

        Write 4 bytes to a block. This is typically used for Ultralight tags.
        Depending on the tag, authentication of the block may be required for
        this method to succeed.

        Parameters:
        -----------

        block:  The block to write

        contents:  A 4 byte string containing the data to write

        true if successful, false otherwise 
        """
        return _pyupm_sm130.SM130_writeBlock4(self, *args)

    def writeKey(self, *args):
        """
        writeKey(SM130 self, uint8_t eepromSector, upm::SM130::KEY_TYPES_T keyType, std::string key) -> bool

        Parameters:
            eepromSector: uint8_t
            keyType: enum upm::SM130::KEY_TYPES_T
            key: std::string


        bool writeKey(uint8_t
        eepromSector, KEY_TYPES_T keyType, std::string key)

        Write a key into one of the 16 EEPROM key slots. This can be a Type A
        or Type B key. It is not possible to read these keys once written.
        Once stored, the key can be used for authentication without having to
        send the key itself. You can then use the appropriate
        KEY_TYPE_EEPROM_* keyTypes in a call to authenticate().

        Parameters:
        -----------

        eepromSector:  A number between 0 and 15, indicating the EEPROM sector
        you want to store the key in

        keyType:  Either KEY_TYPE_A or KEY_TYPE_B

        key:  The 6 byte key to store in the EEPROM

        true if successful, false otherwise 
        """
        return _pyupm_sm130.SM130_writeKey(self, *args)

    def adjustValueBlock(self, *args):
        """
        adjustValueBlock(SM130 self, uint8_t block, int32_t value, bool incr) -> int32_t

        Parameters:
            block: uint8_t
            value: int32_t
            incr: bool


        int32_t
        adjustValueBlock(uint8_t block, int32_t value, bool incr)

        Increment or decrement a value block.

        Parameters:
        -----------

        block:  The block to adjust

        value:  The number to increment or decrement the value block by

        incr:  true to increment, false to decrement

        The contents of the value block after the operation has completed. 
        """
        return _pyupm_sm130.SM130_adjustValueBlock(self, *args)

    def setAntennaPower(self, *args):
        """
        setAntennaPower(SM130 self, bool on) -> bool

        Parameters:
            on: bool


        bool
        setAntennaPower(bool on)

        Turn the antenna power on or off. The power is on by default after a
        reset. If you turn off the antenna, and methods used for interacting
        with tags will fail until power is re-enabled.

        Parameters:
        -----------

        on:  true to enable antenna power, false to disable

        true if successful, false otherwise 
        """
        return _pyupm_sm130.SM130_setAntennaPower(self, *args)

    def readPorts(self):
        """
        readPorts(SM130 self) -> uint8_t

        Parameters:
            self: upm::SM130 *


        uint8_t readPorts()

        Read the status of the 2 onboard GPIO input pins. Bit 0 is for input
        0, bit 1 for input 1. All other bits will be 0.

        bitmask of input port status values 
        """
        return _pyupm_sm130.SM130_readPorts(self)

    def writePorts(self, *args):
        """
        writePorts(SM130 self, uint8_t val) -> bool

        Parameters:
            val: uint8_t


        bool
        writePorts(uint8_t val)

        Set the output status of the 2 onboard gpio outputs. Bit 0 is for
        output 0, bit 1 for output 1. All other bits will be discarded.

        Parameters:
        -----------

        val:  bitmask of output status bits to write

        true if successful, false otherwise 
        """
        return _pyupm_sm130.SM130_writePorts(self, *args)

    def haltTag(self):
        """
        haltTag(SM130 self) -> bool

        Parameters:
            self: upm::SM130 *


        bool haltTag()

        Halts a tag. Once a tag is halted, it cannot be accessed until it is
        removed and reinserted into the RF field and selected.

        true if successful, false otherwise 
        """
        return _pyupm_sm130.SM130_haltTag(self)

    def setSM130BaudRate(self, *args):
        """
        setSM130BaudRate(SM130 self, int baud) -> bool

        Parameters:
            baud: int


        bool
        setSM130BaudRate(int baud)

        Changes the baud rate of the SM130. WARNING: This is a potentially
        dangerous command that could cause you to lose contact with the
        device. Once the command is validated and issued, the host baudrate
        will be changed to match, and this method will wait for a response at
        the new baudrate for up to 1 second.

        If this response does not arrive, the old baudrate will be restored,
        though there is no way to know whether the SM130 actually
        succeessfully executed the baudrate change.

        Once the SM130 has changed it's baudrate, the new value will be stored
        in it's EEPROM, and any further access to the device will need to use
        the new baudrate. This is true even after a power on reset.

        Parameters:
        -----------

        baud:  The new baud rate to set. Valid values are 9600, 19200, 38400,
        57600, and 115200.

        true if successful, false otherwise 
        """
        return _pyupm_sm130.SM130_setSM130BaudRate(self, *args)

    def sleep(self):
        """
        sleep(SM130 self) -> bool

        Parameters:
            self: upm::SM130 *


        bool sleep()

        Put the SM130 to sleep. Once the device has been put to sleep, the
        only way to wake it is via hardwareReset() or a power cycle.

        true if successful, false otherwise 
        """
        return _pyupm_sm130.SM130_sleep(self)

    def getLastErrorCode(self):
        """
        getLastErrorCode(SM130 self) -> char

        Parameters:
            self: upm::SM130 *


        char
        getLastErrorCode()

        Get the last error that occurred. After a successful operation, this
        will be 0. See the datasheet for the various errors that can occur in
        various circumstances.

        The last error code, or 0 if the last operation succeeded. 
        """
        return _pyupm_sm130.SM130_getLastErrorCode(self)

    def getLastErrorString(self):
        """
        getLastErrorString(SM130 self) -> std::string

        Parameters:
            self: upm::SM130 *


        std::string
        getLastErrorString()

        Get the text representation of the last error that occurred. The
        returned string is empty if the last operation completed successfully.

        The last error string if an error occurred, or an empty string if the
        last operation succeeded. 
        """
        return _pyupm_sm130.SM130_getLastErrorString(self)

    def getUIDLen(self):
        """
        getUIDLen(SM130 self) -> int

        Parameters:
            self: upm::SM130 *


        int getUIDLen()

        Get the UID length of the currently selected tag.

        The UID length of the currently selected tag, or 0 if no tag is
        currently selected. 
        """
        return _pyupm_sm130.SM130_getUIDLen(self)

    def getUID(self):
        """
        getUID(SM130 self) -> std::string

        Parameters:
            self: upm::SM130 *


        std::string getUID()

        Get the UID of the currently selected tag.

        The UID of the currently selected tag, or an empty string if no tag is
        currently selected. 
        """
        return _pyupm_sm130.SM130_getUID(self)

    def getTagType(self):
        """
        getTagType(SM130 self) -> upm::SM130::TAG_TYPE_T

        Parameters:
            self: upm::SM130 *


        TAG_TYPE_T
        getTagType()

        Get the tag type of the currently selected tag.

        The tag type of the currently selected tag, or TAG_NONE if no tag is
        currently selected. 
        """
        return _pyupm_sm130.SM130_getTagType(self)

    def tag2String(self, *args):
        """
        tag2String(SM130 self, upm::SM130::TAG_TYPE_T tag) -> std::string

        Parameters:
            tag: enum upm::SM130::TAG_TYPE_T


        string
        tag2String(TAG_TYPE_T tag)

        Convert the supplied tag type into a human readable string.

        Parameters:
        -----------

        tag:  One of the TAG_TYPE_T values

        A string representation of the supplied tag type 
        """
        return _pyupm_sm130.SM130_tag2String(self, *args)

    def string2HexString(self, *args):
        """
        string2HexString(SM130 self, std::string input) -> std::string

        Parameters:
            input: std::string


        string
        string2HexString(std::string input)

        This is a convenience function that converts a supplied string into a
        space separated hex formatted string. This can be useful for printing
        out binary data in a human readable format, like the UID.

        Parameters:
        -----------

        input:  The string to convert

        A string representation of the input in space separated hex values 
        """
        return _pyupm_sm130.SM130_string2HexString(self, *args)

SM130_swigregister = _pyupm_sm130.SM130_swigregister
SM130_swigregister(SM130)

# This file is compatible with both classic and new-style classes.


