# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.





from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_pyupm_hx711', [dirname(__file__)])
        except ImportError:
            import _pyupm_hx711
            return _pyupm_hx711
        if fp is not None:
            try:
                _mod = imp.load_module('_pyupm_hx711', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _pyupm_hx711 = swig_import_helper()
    del swig_import_helper
else:
    import _pyupm_hx711
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


class HX711(_object):
    """
    API for the HX711 Analog-to-Digital Converter.

    ID: hx711

    Name: HX711 Analog-to-Digital Converter

    Category: electric

    Manufacturer: generic

    Link:http://www.dfrobot.com/image/data/SEN0160/hx711_english.pdf

    Connection: gpio  HX711 is a precision 24-bit analog-to-digital
    converter (ADC) designed for weight scales and industrial control
    applications to interface directly with a bridge sensor. This module
    was tested on the Intel(R) Galileo Gen 2 board.

    C++ includes: hx711.h 
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HX711, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HX711, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(upm::HX711 self, uint8_t data, uint8_t sck, uint8_t gain=128) -> HX711

        Parameters:
            data: uint8_t
            sck: uint8_t
            gain: uint8_t

        __init__(upm::HX711 self, uint8_t data, uint8_t sck) -> HX711

        Parameters:
            data: uint8_t
            sck: uint8_t


        HX711(uint8_t data, uint8_t
        sck, uint8_t gain=128)

        HX711 constructor

        Parameters:
        -----------

        data:  Defines the data pin

        sck:  Defines the clock pin

        gain:  Defines the gain factor Valid values are 128 or 64 for channel
        A; channel B works with a 32-gain factor only 
        """
        this = _pyupm_hx711.new_HX711(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _pyupm_hx711.delete_HX711
    __del__ = lambda self : None;
    def read(self):
        """
        read(HX711 self) -> unsigned long

        Parameters:
            self: upm::HX711 *


        unsigned long read()

        Waits for the chip to be ready and returns a reading

        Raw ADC reading 
        """
        return _pyupm_hx711.HX711_read(self)

    def setGain(self, gain=128):
        """
        setGain(HX711 self, uint8_t gain=128)

        Parameters:
            gain: uint8_t

        setGain(HX711 self)

        Parameters:
            self: upm::HX711 *


        void setGain(uint8_t
        gain=128)

        Sets the gain factor; takes effect only after a call to read() channel
        A can be set for a 128 or 64 gain; channel B has a fixed 32-gain
        factor depending on the parameter; the channel is also set to either A
        or B

        Parameters:
        -----------

        gain:  Defines the gain factor 
        """
        return _pyupm_hx711.HX711_setGain(self, gain)

    def readAverage(self, times=10):
        """
        readAverage(HX711 self, uint8_t times=10) -> unsigned long

        Parameters:
            times: uint8_t

        readAverage(HX711 self) -> unsigned long

        Parameters:
            self: upm::HX711 *


        unsigned long
        readAverage(uint8_t times=10)

        Returns an average reading

        Parameters:
        -----------

        times:  Defines how many reading to do

        Average reading 
        """
        return _pyupm_hx711.HX711_readAverage(self, times)

    def getValue(self, times=10):
        """
        getValue(HX711 self, uint8_t times=10) -> double

        Parameters:
            times: uint8_t

        getValue(HX711 self) -> double

        Parameters:
            self: upm::HX711 *


        double getValue(uint8_t
        times=10)

        Returns ( readAverage() - OFFSET)

        Parameters:
        -----------

        times:  Defines how many readings to do

        Current value without the tare weight 
        """
        return _pyupm_hx711.HX711_getValue(self, times)

    def getUnits(self, times=1):
        """
        getUnits(HX711 self, uint8_t times=1) -> float

        Parameters:
            times: uint8_t

        getUnits(HX711 self) -> float

        Parameters:
            self: upm::HX711 *


        float getUnits(uint8_t
        times=1)

        Returns getValue() divided by SCALE

        Parameters:
        -----------

        times:  Defines how many readings to do

        Raw value divided by a value obtained via calibration 
        """
        return _pyupm_hx711.HX711_getUnits(self, times)

    def tare(self, times=10):
        """
        tare(HX711 self, uint8_t times=10)

        Parameters:
            times: uint8_t

        tare(HX711 self)

        Parameters:
            self: upm::HX711 *


        void tare(uint8_t times=10)

        Sets the OFFSET value for the tare weight

        Parameters:
        -----------

        times:  Defines how many times to read the tare value 
        """
        return _pyupm_hx711.HX711_tare(self, times)

    def setScale(self, scale=1.):
        """
        setScale(HX711 self, float scale=1.)

        Parameters:
            scale: float

        setScale(HX711 self)

        Parameters:
            self: upm::HX711 *


        void setScale(float
        scale=1.f)

        Sets the SCALE value This value is used to convert the raw data to
        human-readable data (measurement units)

        Parameters:
        -----------

        scale:  Value obtained via calibration 
        """
        return _pyupm_hx711.HX711_setScale(self, scale)

HX711_swigregister = _pyupm_hx711.HX711_swigregister
HX711_swigregister(HX711)

# This file is compatible with both classic and new-style classes.


