/*
 * Decompiled with CFR 0.152.
 */
package sun.security.smartcardio;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.util.Debug;

class PlatformPCSC {
    static final Debug debug = Debug.getInstance("pcsc");
    static final Throwable initException = AccessController.doPrivileged(new PrivilegedAction<Throwable>(){

        @Override
        public Throwable run() {
            try {
                System.loadLibrary("j2pcsc");
                String string = PlatformPCSC.getLibraryName();
                if (debug != null) {
                    debug.println("Using PC/SC library: " + string);
                }
                PlatformPCSC.initialize(string);
                return null;
            }
            catch (Throwable throwable) {
                return throwable;
            }
        }
    });
    private static final String PROP_NAME = "sun.security.smartcardio.library";
    private static final String LIB0 = "libpcsclite.so.1";
    private static final String LIB1 = "/usr/$LIBISA/libpcsclite.so";
    private static final String LIB2 = "/usr/local/$LIBISA/libpcsclite.so";
    private static final String PCSC_FRAMEWORK = "/System/Library/Frameworks/PCSC.framework/Versions/Current/PCSC";
    static final int SCARD_PROTOCOL_T0 = 1;
    static final int SCARD_PROTOCOL_T1 = 2;
    static final int SCARD_PROTOCOL_RAW = 4;
    static final int SCARD_UNKNOWN = 1;
    static final int SCARD_ABSENT = 2;
    static final int SCARD_PRESENT = 4;
    static final int SCARD_SWALLOWED = 8;
    static final int SCARD_POWERED = 16;
    static final int SCARD_NEGOTIABLE = 32;
    static final int SCARD_SPECIFIC = 64;

    PlatformPCSC() {
    }

    private static String expand(String string) {
        int n = string.indexOf("$LIBISA");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 7);
        String string4 = "64".equals(System.getProperty("sun.arch.data.model")) ? ("SunOS".equals(System.getProperty("os.name")) ? "lib/64" : "lib64") : "lib";
        String string5 = string2 + string4 + string3;
        return string5;
    }

    private static String getLibraryName() throws IOException {
        String string = PlatformPCSC.expand(System.getProperty(PROP_NAME, "").trim());
        if (string.length() != 0) {
            return string;
        }
        string = LIB0;
        return string;
    }

    private static native void initialize(String var0);
}

