/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import sun.awt.X11.XAtom;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XToolkitThreadBlockedHandler;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;

public class XDataTransferer
extends DataTransferer {
    static final XAtom FILE_NAME_ATOM = XAtom.get("FILE_NAME");
    static final XAtom DT_NET_FILE_ATOM = XAtom.get("_DT_NETFILE");
    static final XAtom PNG_ATOM = XAtom.get("PNG");
    static final XAtom JFIF_ATOM = XAtom.get("JFIF");
    static final XAtom TARGETS_ATOM = XAtom.get("TARGETS");
    static final XAtom INCR_ATOM = XAtom.get("INCR");
    static final XAtom MULTIPLE_ATOM = XAtom.get("MULTIPLE");
    private static XDataTransferer transferer;
    private static ImageTypeSpecifier defaultSpecifier;

    private XDataTransferer() {
    }

    static synchronized XDataTransferer getInstanceImpl() {
        if (transferer == null) {
            transferer = new XDataTransferer();
        }
        return transferer;
    }

    @Override
    public String getDefaultUnicodeEncoding() {
        return "iso-10646-ucs-2";
    }

    @Override
    public boolean isLocaleDependentTextFormat(long l) {
        return false;
    }

    @Override
    public boolean isTextFormat(long l) {
        return super.isTextFormat(l) || this.isMimeFormat(l, "text");
    }

    @Override
    protected String getCharsetForTextFormat(Long l) {
        long l2 = l;
        if (this.isMimeFormat(l2, "text")) {
            String string = this.getNativeForFormat(l2);
            DataFlavor dataFlavor = new DataFlavor(string, null);
            if (!DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
                return null;
            }
            String string2 = dataFlavor.getParameter("charset");
            if (string2 != null) {
                return string2;
            }
        }
        return super.getCharsetForTextFormat(l);
    }

    @Override
    protected boolean isURIListFormat(long l) {
        String string = this.getNativeForFormat(l);
        if (string == null) {
            return false;
        }
        try {
            DataFlavor dataFlavor = new DataFlavor(string);
            if (dataFlavor.getPrimaryType().equals("text") && dataFlavor.getSubType().equals("uri-list")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isFileFormat(long l) {
        return l == FILE_NAME_ATOM.getAtom() || l == DT_NET_FILE_ATOM.getAtom();
    }

    @Override
    public boolean isImageFormat(long l) {
        return l == PNG_ATOM.getAtom() || l == JFIF_ATOM.getAtom() || this.isMimeFormat(l, "image");
    }

    @Override
    protected Long getFormatForNativeAsLong(String string) {
        long l = XAtom.get(string).getAtom();
        return l;
    }

    @Override
    protected String getNativeForFormat(long l) {
        return this.getTargetNameForAtom(l);
    }

    @Override
    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return XToolkitThreadBlockedHandler.getToolkitThreadBlockedHandler();
    }

    private String getTargetNameForAtom(long l) {
        return XAtom.get(l).getName();
    }

    @Override
    protected byte[] imageToPlatformBytes(Image image, long l) throws IOException {
        String string;
        String string2 = null;
        if (l == PNG_ATOM.getAtom()) {
            string2 = "image/png";
        } else if (l == JFIF_ATOM.getAtom()) {
            string2 = "image/jpeg";
        } else {
            try {
                string = this.getNativeForFormat(l);
                DataFlavor dataFlavor = new DataFlavor(string);
                String string3 = dataFlavor.getPrimaryType();
                if ("image".equals(string3)) {
                    string2 = dataFlavor.getPrimaryType() + "/" + dataFlavor.getSubType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null) {
            return this.imageToStandardBytes(image, string2);
        }
        string = this.getNativeForFormat(l);
        throw new IOException("Translation to " + string + " is not supported.");
    }

    @Override
    protected ByteArrayOutputStream convertFileListToBytes(ArrayList<String> arrayList) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray = arrayList.get(i).getBytes();
            if (i != 0) {
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        return byteArrayOutputStream;
    }

    @Override
    protected Image platformImageBytesToImage(byte[] byArray, long l) throws IOException {
        String string;
        String string2 = null;
        if (l == PNG_ATOM.getAtom()) {
            string2 = "image/png";
        } else if (l == JFIF_ATOM.getAtom()) {
            string2 = "image/jpeg";
        } else {
            try {
                string = this.getNativeForFormat(l);
                DataFlavor dataFlavor = new DataFlavor(string);
                String string3 = dataFlavor.getPrimaryType();
                if ("image".equals(string3)) {
                    string2 = dataFlavor.getPrimaryType() + "/" + dataFlavor.getSubType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null) {
            return this.standardImageBytesToImage(byArray, string2);
        }
        string = this.getNativeForFormat(l);
        throw new IOException("Translation from " + string + " is not supported.");
    }

    @Override
    protected String[] dragQueryFile(byte[] byArray) {
        XToolkit.awtLock();
        try {
            String[] stringArray = XlibWrapper.XTextPropertyToStringList(byArray, XAtom.get("STRING").getAtom());
            return stringArray;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URI[] dragQueryURIs(InputStream inputStream, long l, Transferable transferable) throws IOException {
        String string = null;
        if (transferable != null && this.isLocaleDependentTextFormat(l) && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
            try {
                string = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {}
        } else {
            string = this.getCharsetForTextFormat(l);
        }
        if (string == null) {
            string = XDataTransferer.getDefaultTextCharset();
        }
        try (BufferedReader bufferedReader = null;){
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            ArrayList<URI> arrayList = new ArrayList<URI>();
            while ((string2 = bufferedReader.readLine()) != null) {
                try {
                    if ("\u0000".equals(string2)) continue;
                    arrayList.add(new URI(string2));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IOException(uRISyntaxException);
                }
            }
            URI[] uRIArray = arrayList.toArray(new URI[arrayList.size()]);
            return uRIArray;
        }
    }

    private boolean isMimeFormat(long l, String string) {
        String string2 = this.getNativeForFormat(l);
        if (string2 == null) {
            return false;
        }
        try {
            DataFlavor dataFlavor = new DataFlavor(string2);
            if (string.equals(dataFlavor.getPrimaryType())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public LinkedHashSet<DataFlavor> getPlatformMappingsForNative(String string) {
        Iterator<ImageReader> iterator;
        LinkedHashSet<DataFlavor> linkedHashSet = new LinkedHashSet<DataFlavor>();
        if (string == null) {
            return linkedHashSet;
        }
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor(string);
        }
        catch (Exception exception) {
            return linkedHashSet;
        }
        DataFlavor dataFlavor2 = dataFlavor;
        String string2 = dataFlavor.getPrimaryType();
        String string3 = string2 + "/" + dataFlavor.getSubType();
        if ("image".equals(string2) && (iterator = ImageIO.getImageReadersByMIMEType(string3)).hasNext()) {
            linkedHashSet.add(DataFlavor.imageFlavor);
        }
        linkedHashSet.add(dataFlavor2);
        return linkedHashSet;
    }

    private ImageTypeSpecifier getDefaultImageTypeSpecifier() {
        if (defaultSpecifier == null) {
            ColorModel colorModel = ColorModel.getRGBdefault();
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(10, 10);
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            defaultSpecifier = new ImageTypeSpecifier(bufferedImage);
        }
        return defaultSpecifier;
    }

    @Override
    public LinkedHashSet<String> getPlatformMappingsForFlavor(DataFlavor dataFlavor) {
        String string;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(1);
        if (dataFlavor == null) {
            return linkedHashSet;
        }
        String string2 = dataFlavor.getParameter("charset");
        String string3 = string = dataFlavor.getPrimaryType() + "/" + dataFlavor.getSubType();
        if (string2 != null && DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            string3 = string3 + ";charset=" + string2;
        }
        if (dataFlavor.getRepresentationClass() != null && (dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassByteBuffer() || byte[].class.equals(dataFlavor.getRepresentationClass()))) {
            linkedHashSet.add(string3);
        }
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            String[] stringArray = ImageIO.getWriterMIMETypes();
            if (stringArray != null) {
                block0: for (int i = 0; i < stringArray.length; ++i) {
                    Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(stringArray[i]);
                    while (iterator.hasNext()) {
                        ImageWriter imageWriter = iterator.next();
                        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
                        if (imageWriterSpi == null || !imageWriterSpi.canEncodeImage(this.getDefaultImageTypeSpecifier())) continue;
                        linkedHashSet.add(stringArray[i]);
                        continue block0;
                    }
                }
            }
        } else if (DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            if (DataFlavor.stringFlavor.equals(dataFlavor)) {
                string = "text/plain";
            }
            for (String string4 : DataTransferer.standardEncodings()) {
                if (string4.equals(string2)) continue;
                linkedHashSet.add(string + ";charset=" + string4);
            }
            if (!linkedHashSet.contains(string)) {
                linkedHashSet.add(string);
            }
        }
        return linkedHashSet;
    }

    static {
        defaultSpecifier = null;
    }
}

