/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioPermission;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.classpath.icedtea.pulseaudio.ContextEvent;
import org.classpath.icedtea.pulseaudio.ContextListener;
import org.classpath.icedtea.pulseaudio.Debug;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.PulseAudioClip;
import org.classpath.icedtea.pulseaudio.PulseAudioLine;
import org.classpath.icedtea.pulseaudio.PulseAudioMixerInfo;
import org.classpath.icedtea.pulseaudio.PulseAudioSourceDataLine;
import org.classpath.icedtea.pulseaudio.PulseAudioSourcePort;
import org.classpath.icedtea.pulseaudio.PulseAudioTargetDataLine;
import org.classpath.icedtea.pulseaudio.PulseAudioTargetPort;

public final class PulseAudioMixer
implements Mixer {
    private Thread eventLoopThread;
    private List<Line.Info> sourceLineInfos = new ArrayList<Line.Info>();
    private List<Line.Info> staticSourceLineInfos = new ArrayList<Line.Info>();
    private List<Line.Info> targetLineInfos = new ArrayList<Line.Info>();
    private List<Line.Info> staticTargetLineInfos = new ArrayList<Line.Info>();
    private static PulseAudioMixer _instance = null;
    private static final String DEFAULT_APP_NAME = "Java";
    static final String PULSEAUDIO_FORMAT_KEY = "PulseAudioFormatKey";
    private boolean isOpen = false;
    private final List<PulseAudioLine> sourceLines = new ArrayList<PulseAudioLine>();
    private final List<PulseAudioLine> targetLines = new ArrayList<PulseAudioLine>();
    private final List<LineListener> lineListeners = new ArrayList<LineListener>();

    private PulseAudioMixer() {
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioMixer.PulseAudioMixer(): Contructing PulseAudioMixer...");
        AudioFormat[] formats = this.getSupportedFormats();
        this.staticSourceLineInfos.add(new DataLine.Info(SourceDataLine.class, formats, 0, 1000000));
        this.staticSourceLineInfos.add(new DataLine.Info(Clip.class, formats, 0, 1000000));
        this.staticTargetLineInfos.add(new DataLine.Info(TargetDataLine.class, formats, 0, 1000000));
        this.refreshSourceAndTargetLines();
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioMixer.PulseAudioMixer(): Finished constructing PulseAudioMixer");
    }

    public static synchronized PulseAudioMixer getInstance() {
        if (_instance == null) {
            _instance = new PulseAudioMixer();
        }
        return _instance;
    }

    private AudioFormat[] getSupportedFormats() {
        int sampleSize;
        HashMap<String, Object> properties;
        int[] channelSizes;
        ArrayList<AudioFormat> supportedFormats = new ArrayList<AudioFormat>();
        for (int channelSize : channelSizes = new int[]{1, 2, 3, 4, 5, 6}) {
            properties = new HashMap<String, Object>();
            properties.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_ALAW");
            sampleSize = 8;
            AudioFormat PA_SAMPLE_ALAW = new AudioFormat(AudioFormat.Encoding.ALAW, -1.0f, sampleSize, channelSize, sampleSize / 8 * channelSize, -1.0f, false, properties);
            supportedFormats.add(PA_SAMPLE_ALAW);
        }
        for (int channelSize : channelSizes) {
            properties = new HashMap();
            properties.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_ULAW");
            sampleSize = 8;
            AudioFormat PA_SAMPLE_ULAW = new AudioFormat(AudioFormat.Encoding.ULAW, -1.0f, sampleSize, channelSize, sampleSize / 8 * channelSize, -1.0f, false, properties);
            supportedFormats.add(PA_SAMPLE_ULAW);
        }
        for (int channelSize : channelSizes) {
            properties = new HashMap();
            properties.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_S16BE");
            sampleSize = 16;
            AudioFormat PA_SAMPLE_S16BE = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, sampleSize, channelSize, sampleSize / 8 * channelSize, -1.0f, true, properties);
            supportedFormats.add(PA_SAMPLE_S16BE);
        }
        for (int channelSize : channelSizes) {
            properties = new HashMap();
            properties.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_S16LE");
            sampleSize = 16;
            AudioFormat A_SAMPLE_S16LE = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, sampleSize, channelSize, sampleSize / 8 * channelSize, -1.0f, false, properties);
            supportedFormats.add(A_SAMPLE_S16LE);
        }
        for (int channelSize : channelSizes) {
            properties = new HashMap();
            properties.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_S32BE");
            sampleSize = 32;
            AudioFormat PA_SAMPLE_S32BE = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, sampleSize, channelSize, sampleSize / 8 * channelSize, -1.0f, true, properties);
            supportedFormats.add(PA_SAMPLE_S32BE);
        }
        for (int channelSize : channelSizes) {
            properties = new HashMap();
            properties.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_S32LE");
            sampleSize = 32;
            AudioFormat PA_SAMPLE_S32LE = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, sampleSize, channelSize, sampleSize / 8 * channelSize, -1.0f, false, properties);
            supportedFormats.add(PA_SAMPLE_S32LE);
        }
        for (int channelSize : channelSizes) {
            properties = new HashMap();
            properties.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_U8");
            sampleSize = 8;
            AudioFormat PA_SAMPLE_U8 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, sampleSize, channelSize, sampleSize / 8 * channelSize, -1.0f, false, properties);
            supportedFormats.add(PA_SAMPLE_U8);
        }
        return supportedFormats.toArray(new AudioFormat[0]);
    }

    @Override
    public Line getLine(Line.Info info) throws LineUnavailableException {
        if (!this.isLineSupported(info)) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        AudioFormat[] formats = null;
        AudioFormat defaultFormat = null;
        if (DataLine.Info.class.isInstance(info)) {
            ArrayList<AudioFormat> formatList = new ArrayList<AudioFormat>();
            AudioFormat[] requestedFormats = ((DataLine.Info)info).getFormats();
            for (int i = 0; i < requestedFormats.length; ++i) {
                AudioFormat f1 = requestedFormats[i];
                for (AudioFormat f2 : this.getSupportedFormats()) {
                    if (!f1.matches(f2)) continue;
                    formatList.add(f2);
                    defaultFormat = f1;
                }
            }
            formats = formatList.toArray(new AudioFormat[0]);
        } else {
            formats = this.getSupportedFormats();
            defaultFormat = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 44100.0f, 8, 2, 2, -1.0f, false);
        }
        if (info.getLineClass() == SourceDataLine.class) {
            return new PulseAudioSourceDataLine(formats, defaultFormat);
        }
        if (info.getLineClass() == TargetDataLine.class) {
            AudioPermission perm = new AudioPermission("record", null);
            perm.checkGuard(null);
            return new PulseAudioTargetDataLine(formats, defaultFormat);
        }
        if (info.getLineClass() == Clip.class) {
            return new PulseAudioClip(formats, defaultFormat);
        }
        if (Port.Info.class.isInstance(info)) {
            Port.Info portInfo = (Port.Info)info;
            if (portInfo.isSource()) {
                AudioPermission perm = new AudioPermission("record", null);
                perm.checkGuard(null);
                return new PulseAudioSourcePort(portInfo.getName());
            }
            return new PulseAudioTargetPort(portInfo.getName());
        }
        Debug.println(Debug.DebugLevel.Info, "PulseAudioMixer.getLine(): No matching line supported by PulseAudio");
        throw new IllegalArgumentException("No matching lines found");
    }

    @Override
    public int getMaxLines(Line.Info info) {
        if (this.isLineSupported(info)) {
            return -1;
        }
        return 0;
    }

    @Override
    public Mixer.Info getMixerInfo() {
        return PulseAudioMixerInfo.getInfo();
    }

    @Override
    public Line.Info[] getSourceLineInfo() {
        return this.sourceLineInfos.toArray(new Line.Info[0]);
    }

    @Override
    public Line.Info[] getSourceLineInfo(Line.Info info) {
        ArrayList<Line.Info> infos = new ArrayList<Line.Info>();
        for (Line.Info supportedInfo : this.sourceLineInfos) {
            if (!info.matches(supportedInfo)) continue;
            infos.add(supportedInfo);
        }
        return infos.toArray(new Line.Info[0]);
    }

    @Override
    public Line[] getSourceLines() {
        return this.sourceLines.toArray(new Line[0]);
    }

    @Override
    public Line.Info[] getTargetLineInfo() {
        return this.targetLineInfos.toArray(new Line.Info[0]);
    }

    @Override
    public Line.Info[] getTargetLineInfo(Line.Info info) {
        ArrayList<Line.Info> infos = new ArrayList<Line.Info>();
        for (Line.Info supportedInfo : this.targetLineInfos) {
            if (!info.matches(supportedInfo)) continue;
            infos.add(supportedInfo);
        }
        return infos.toArray(new Line.Info[0]);
    }

    @Override
    public Line[] getTargetLines() {
        AudioPermission perm = new AudioPermission("record", null);
        perm.checkGuard(null);
        return this.targetLines.toArray(new Line[0]);
    }

    @Override
    public boolean isLineSupported(Line.Info info) {
        if (info != null) {
            for (Line.Info myInfo : this.sourceLineInfos) {
                if (!info.matches(myInfo)) continue;
                return true;
            }
            for (Line.Info myInfo : this.targetLineInfos) {
                if (!info.matches(myInfo)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSynchronizationSupported(Line[] lines, boolean maintainSync) {
        return false;
    }

    @Override
    public void synchronize(Line[] lines, boolean maintainSync) {
        throw new IllegalArgumentException("Mixer does not support synchronizing lines");
    }

    @Override
    public void unsynchronize(Line[] lines) {
        throw new IllegalArgumentException();
    }

    @Override
    public void addLineListener(LineListener listener) {
        this.lineListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (!this.isOpen) {
            throw new IllegalStateException("Mixer is not open; cant close");
        }
        LinkedList<PulseAudioLine> linesToClose = new LinkedList<PulseAudioLine>();
        linesToClose.addAll(this.sourceLines);
        if (this.sourceLines.size() > 0) {
            Debug.println(Debug.DebugLevel.Warning, "PulseAudioMixer.close(): " + linesToClose.size() + " source lines were not closed. closing them now.");
            linesToClose.addAll(this.sourceLines);
            for (Line line : linesToClose) {
                if (!line.isOpen()) continue;
                line.close();
            }
        }
        linesToClose.clear();
        if (this.targetLines.size() > 0) {
            Debug.println(Debug.DebugLevel.Warning, "PulseAudioMixer.close(): " + linesToClose.size() + " target lines have not been closed");
            linesToClose.addAll(this.targetLines);
            for (Line line : linesToClose) {
                if (!line.isOpen()) continue;
                line.close();
            }
        }
        Iterator iterator = this.lineListeners;
        synchronized (iterator) {
            this.lineListeners.clear();
        }
        this.eventLoopThread.interrupt();
        try {
            this.eventLoopThread.join();
        }
        catch (InterruptedException e) {
            System.out.println(this.getClass().getName() + ": interrupted while waiting for eventloop to finish");
        }
        this.isOpen = false;
        this.refreshSourceAndTargetLines();
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioMixer.close(): Mixer closed");
    }

    @Override
    public Control getControl(Control.Type control) {
        throw new IllegalArgumentException();
    }

    @Override
    public Control[] getControls() {
        return new Control[0];
    }

    @Override
    public Line.Info getLineInfo() {
        return new Line.Info(PulseAudioMixer.class);
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void open() throws LineUnavailableException {
        this.openLocal();
    }

    public void openLocal() throws LineUnavailableException {
        this.openLocal(DEFAULT_APP_NAME);
    }

    public void openLocal(String appName) throws LineUnavailableException {
        this.openImpl(appName, null);
    }

    public void openRemote(String appName, String host) throws UnknownHostException, LineUnavailableException {
        if (host == null) {
            throw new NullPointerException("hostname");
        }
        int PULSEAUDIO_DEFAULT_PORT = 4713;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(host, 4713);
        }
        this.openImpl(appName, host);
    }

    public void openRemote(String appName, String host, int port) throws UnknownHostException, LineUnavailableException {
        if (port < 1 && port != -1) {
            throw new IllegalArgumentException("Invalid value for port");
        }
        if (host == null) {
            throw new NullPointerException("hostname");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(host, port);
        }
        InetAddress addr = InetAddress.getAllByName(host)[0];
        host = addr.getHostAddress();
        host = host + ":" + String.valueOf(port);
        this.openImpl(appName, host);
    }

    private synchronized void openImpl(String appName, String hostAndIp) throws LineUnavailableException {
        if (this.isOpen) {
            throw new IllegalStateException("Mixer is already open");
        }
        EventLoop eventLoop = EventLoop.getEventLoop();
        eventLoop.setAppName(appName);
        eventLoop.setServer(hostAndIp);
        ContextListener generalEventListener = new ContextListener(){

            @Override
            public void update(ContextEvent e) {
                if (e.getType() == ContextEvent.READY) {
                    PulseAudioMixer.this.fireEvent(new LineEvent(PulseAudioMixer.this, LineEvent.Type.OPEN, -1L));
                } else if (e.getType() == ContextEvent.FAILED || e.getType() == ContextEvent.TERMINATED) {
                    PulseAudioMixer.this.fireEvent(new LineEvent(PulseAudioMixer.this, LineEvent.Type.CLOSE, -1L));
                }
            }
        };
        eventLoop.addContextListener(generalEventListener);
        final Semaphore ready = new Semaphore(0);
        ContextListener initListener = new ContextListener(){

            @Override
            public void update(ContextEvent e) {
                if (e.getType() == ContextEvent.READY || e.getType() == ContextEvent.FAILED || e.getType() == ContextEvent.TERMINATED) {
                    ready.release();
                }
            }
        };
        eventLoop.addContextListener(initListener);
        this.eventLoopThread = new Thread((Runnable)eventLoop, "PulseAudio Eventloop Thread");
        this.eventLoopThread.setDaemon(true);
        this.eventLoopThread.start();
        try {
            ready.acquire();
            if (eventLoop.getStatus() != ContextEvent.READY) {
                eventLoop.removeContextListener(initListener);
                this.eventLoopThread.interrupt();
                this.eventLoopThread.join();
                throw new LineUnavailableException();
            }
            eventLoop.removeContextListener(initListener);
        }
        catch (InterruptedException e) {
            System.out.println("PulseAudioMixer: got interrupted while waiting for the EventLoop to initialize");
        }
        this.isOpen = true;
        this.refreshSourceAndTargetLines();
        for (String portName : eventLoop.updateSourcePortNameList()) {
            this.sourceLineInfos.add(new Port.Info(Port.class, portName, true));
        }
        for (String portName : eventLoop.updateTargetPortNameList()) {
            this.targetLineInfos.add(new Port.Info(Port.class, portName, false));
        }
        Debug.println(Debug.DebugLevel.Debug, "PulseAudioMixer.open(): Mixer opened");
    }

    @Override
    public void removeLineListener(LineListener listener) {
        this.lineListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(LineEvent e) {
        List<LineListener> list = this.lineListeners;
        synchronized (list) {
            for (LineListener lineListener : this.lineListeners) {
                lineListener.update(e);
            }
        }
    }

    void addSourceLine(PulseAudioLine line) {
        this.sourceLines.add(line);
    }

    void removeSourceLine(PulseAudioLine line) {
        this.sourceLines.remove(line);
    }

    void addTargetLine(PulseAudioLine line) {
        this.targetLines.add(line);
    }

    void removeTargetLine(PulseAudioLine line) {
        this.targetLines.remove(line);
    }

    void refreshSourceAndTargetLines() {
        this.sourceLineInfos.clear();
        this.targetLineInfos.clear();
        this.sourceLineInfos.addAll(this.staticSourceLineInfos);
        this.targetLineInfos.addAll(this.staticTargetLineInfos);
    }
}

