/*
 * Decompiled with CFR 0.152.
 */
package org.debian.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import org.debian.security.InvalidKeystorePasswordException;
import org.debian.security.KeyStoreHandler;
import org.debian.security.UnableToSaveKeystoreException;
import org.debian.security.UnknownInputException;

public class UpdateCertificates {
    private KeyStoreHandler keystore;

    public static void main(String[] stringArray) throws IOException, GeneralSecurityException {
        String string = "changeit";
        if (stringArray.length == 2 && stringArray[0].equals("-storepass")) {
            string = stringArray[1];
        } else if (stringArray.length > 0) {
            System.err.println("Usage: java org.debian.security.UpdateCertificates [-storepass <password>]");
            System.exit(1);
        }
        try {
            UpdateCertificates updateCertificates = new UpdateCertificates("/etc/ssl/certs/java/cacerts", string);
            updateCertificates.processChanges(new InputStreamReader(System.in, "UTF8"));
            updateCertificates.finish();
        }
        catch (InvalidKeystorePasswordException invalidKeystorePasswordException) {
            invalidKeystorePasswordException.printStackTrace(System.err);
            System.exit(1);
        }
        catch (UnableToSaveKeystoreException unableToSaveKeystoreException) {
            unableToSaveKeystoreException.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public UpdateCertificates(String string, String string2) throws IOException, GeneralSecurityException, InvalidKeystorePasswordException {
        this.keystore = new KeyStoreHandler(string, string2.toCharArray());
    }

    protected void processChanges(Reader reader) throws IOException, GeneralSecurityException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            try {
                this.parseLine(string);
            }
            catch (UnknownInputException unknownInputException) {
                System.err.println("Unknown input: " + string);
            }
        }
    }

    protected void parseLine(String string) throws GeneralSecurityException, IOException, UnknownInputException {
        String string2 = string.substring(1);
        String string3 = string2.substring(string2.lastIndexOf("/") + 1);
        String string4 = "debian:" + string3;
        if (string.startsWith("+")) {
            this.keystore.addAlias(string4, string2);
        } else if (string.startsWith("-")) {
            this.keystore.deleteAlias(string4);
            this.keystore.deleteAlias(string3);
        } else {
            throw new UnknownInputException(string);
        }
    }

    protected void finish() throws GeneralSecurityException, UnableToSaveKeystoreException {
        this.keystore.save();
    }
}

