/*
 * Decompiled with CFR 0.152.
 */
package org.debian.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.debian.security.InvalidKeystorePasswordException;
import org.debian.security.UnableToSaveKeystoreException;

class KeyStoreHandler {
    private String filename;
    private char[] password;
    private KeyStore ks;
    private CertificateFactory certFactory;

    KeyStoreHandler(String string, char[] cArray) throws GeneralSecurityException, IOException, InvalidKeystorePasswordException {
        this.filename = string;
        this.password = cArray;
        this.certFactory = CertificateFactory.getInstance("X.509");
        this.load();
    }

    public void load() throws GeneralSecurityException, IOException, InvalidKeystorePasswordException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File file = new File(this.filename);
        FileInputStream fileInputStream = null;
        if (file.canRead()) {
            fileInputStream = new FileInputStream(file);
        }
        try {
            keyStore.load(fileInputStream, this.password);
        }
        catch (IOException iOException) {
            throw new InvalidKeystorePasswordException("Cannot open Java keystore. Is the password correct?", iOException);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        this.ks = keyStore;
    }

    public void save() throws GeneralSecurityException, UnableToSaveKeystoreException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.filename);
            this.ks.store(fileOutputStream, this.password);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new UnableToSaveKeystoreException("There was a problem saving the new Java keystore.", iOException);
        }
    }

    public void addAlias(String string, String string2) throws KeyStoreException {
        Certificate certificate = this.loadCertificate(string2);
        if (certificate == null) {
            return;
        }
        this.addAlias(string, certificate);
    }

    public void addAlias(String string, Certificate certificate) throws KeyStoreException {
        if (this.contains(string)) {
            System.out.println("Replacing " + string);
            this.ks.deleteEntry(string);
        } else {
            System.out.println("Adding " + string);
        }
        this.ks.setCertificateEntry(string, certificate);
    }

    public void deleteAlias(String string) throws GeneralSecurityException {
        if (this.contains(string)) {
            System.out.println("Removing " + string);
            this.ks.deleteEntry(string);
        }
    }

    public boolean contains(String string) throws KeyStoreException {
        return this.ks.containsAlias(string);
    }

    private Certificate loadCertificate(String string) {
        Certificate certificate = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            certificate = this.certFactory.generateCertificate(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Warning: there was a problem reading the certificate file " + string + ". Message:\n  " + exception.getMessage());
        }
        return certificate;
    }
}

