/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapdump;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.model.ModelProvider;
import com.sun.tools.visualvm.core.snapshot.RegisteredSnapshotCategories;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.core.ui.PluggableDataSourceViewProvider;
import com.sun.tools.visualvm.coredump.CoreDump;
import com.sun.tools.visualvm.heapdump.HeapDump;
import com.sun.tools.visualvm.heapdump.impl.HeapDumpCategory;
import com.sun.tools.visualvm.heapdump.impl.HeapDumpDescriptorProvider;
import com.sun.tools.visualvm.heapdump.impl.HeapDumpProvider;
import com.sun.tools.visualvm.heapdump.impl.HeapDumpViewProvider;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HeapDumpSupport {
    private static HeapDumpSupport instance;
    private final SnapshotCategory category = new HeapDumpCategory();
    private final HeapDumpProvider heapDumpProvider;
    private final HeapDumpViewProvider heapDumpViewProvider;

    public static synchronized HeapDumpSupport getInstance() {
        if (instance == null) {
            instance = new HeapDumpSupport();
        }
        return instance;
    }

    public SnapshotCategory getCategory() {
        return this.category;
    }

    public boolean supportsHeapDump(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        return JvmFactory.getJVMFor((Application)application).isTakeHeapDumpSupported();
    }

    public void takeHeapDump(Application application, boolean openView) {
        this.heapDumpProvider.createHeapDump(application, openView);
    }

    public boolean supportsRemoteHeapDump(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        if (application.isLocalApplication()) {
            return false;
        }
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)application);
        return jmxModel == null ? false : jmxModel.isTakeHeapDumpSupported();
    }

    public void takeRemoteHeapDump(Application application, String dumpFile, boolean customizeDumpFile) {
        this.heapDumpProvider.createRemoteHeapDump(application, dumpFile, customizeDumpFile);
    }

    public void takeHeapDump(CoreDump coreDump, boolean openView) {
        this.heapDumpProvider.createHeapDump(coreDump, openView);
    }

    public PluggableDataSourceViewProvider<HeapDump> getHeapDumpView() {
        return this.heapDumpViewProvider;
    }

    private HeapDumpSupport() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new HeapDumpDescriptorProvider());
        this.heapDumpProvider = new HeapDumpProvider();
        this.heapDumpProvider.initialize();
        this.heapDumpViewProvider = new HeapDumpViewProvider();
        RegisteredSnapshotCategories.sharedInstance().registerCategory(this.category);
        this.heapDumpViewProvider.initialize();
    }
}

