/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import oracle.jvm.hotspot.jfr.StackTrace;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public final class JFRStackTraceRepository
extends VMObject {
    private static int TABLE_SIZE = 2048;
    private static Field nextIDField;
    private static CIntegerField entriesField;
    private static AddressField tableField;

    public JFRStackTraceRepository(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JfrStackTraceRepository");
        nextIDField = type.getField("_next_id");
        entriesField = type.getCIntegerField("_entries");
        tableField = type.getAddressField("_table[TABLE_SIZE]");
    }

    public long getNextID() {
        return nextIDField.getJLong(this.addr);
    }

    public int getEntries() {
        return (int)entriesField.getValue(this.addr);
    }

    public Address getTable() {
        Address tableAddress = this.addr.addOffsetTo(tableField.getOffset() - 1L * VM.getVM().getAddressSize());
        return tableAddress;
    }

    public void write(JFRStreamWriter writer) {
        int entries = this.getEntries();
        Address table = this.getTable();
        if (table == null) {
            return;
        }
        if (entries > 0) {
            writer.write(9);
            writer.write(entries);
            int n = 0;
            for (int i = 0; i < TABLE_SIZE; ++i) {
                Address stacktraceAddr = table.getAddressAt((long)i * VM.getVM().getAddressSize());
                StackTrace stacktrace = (StackTrace)VMObjectFactory.newObject(StackTrace.class, stacktraceAddr);
                while (stacktrace != null) {
                    StackTrace next;
                    ++n;
                    stacktrace.write(writer);
                    stacktrace = next = stacktrace.next();
                }
            }
            this.writeMetaData(writer);
        }
    }

    void writeMetaData(JFRStreamWriter writer) {
        writer.write(47);
        writer.write(3);
        writer.write((byte)0);
        writer.writeString("Interpreted");
        writer.write((byte)1);
        writer.writeString("JIT compiled");
        writer.write((byte)2);
        writer.writeString("Inlined");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JFRStackTraceRepository.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

