/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.net.dns.ResolverConfiguration;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.KdcComm;
import sun.security.krb5.KrbAsReqBuilder;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbServiceLocator;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.SCDynamicStoreConfig;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.EType;
import sun.security.util.SecurityProperties;

public class Config {
    public static final boolean DISABLE_REFERRALS;
    public static final int MAX_REFERRALS;
    private static Config singleton;
    private Hashtable<String, Object> stanzaTable;
    private static boolean DEBUG;
    private static final int BASE16_0 = 1;
    private static final int BASE16_1 = 16;
    private static final int BASE16_2 = 256;
    private static final int BASE16_3 = 4096;
    private final String defaultRealm;
    private final String defaultKDC;

    private static native String getWindowsDirectory(boolean var0);

    public static synchronized Config getInstance() throws KrbException {
        if (singleton == null) {
            singleton = new Config();
        }
        return singleton;
    }

    public static synchronized void refresh() throws KrbException {
        singleton = new Config();
        KdcComm.initStatic();
        EType.initStatic();
        Checksum.initStatic();
        KrbAsReqBuilder.ReferralsState.initStatic();
    }

    private static boolean isMacosLionOrBetter() {
        String string = Config.getProperty("os.name");
        if (!string.contains("OS X")) {
            return false;
        }
        String string2 = Config.getProperty("os.version");
        String[] stringArray = string2.split("\\.");
        if (!stringArray[0].equals("10")) {
            return false;
        }
        if (stringArray.length < 2) {
            return false;
        }
        try {
            int n = Integer.parseInt(stringArray[1]);
            if (n >= 7) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private Config() throws KrbException {
        block11: {
            this.stanzaTable = new Hashtable();
            String string = Config.getProperty("java.security.krb5.kdc");
            this.defaultKDC = string != null ? string.replace(':', ' ') : null;
            this.defaultRealm = Config.getProperty("java.security.krb5.realm");
            if (this.defaultKDC == null && this.defaultRealm != null || this.defaultRealm == null && this.defaultKDC != null) {
                throw new KrbException("System property java.security.krb5.kdc and java.security.krb5.realm both must be set or neither must be set.");
            }
            try {
                String string2 = this.getJavaFileName();
                if (string2 != null) {
                    List<String> list = this.loadConfigFile(string2);
                    this.stanzaTable = this.parseStanzaTable(list);
                    if (DEBUG) {
                        System.out.println("Loaded from Java config");
                    }
                    break block11;
                }
                boolean bl = false;
                if (Config.isMacosLionOrBetter()) {
                    try {
                        this.stanzaTable = SCDynamicStoreConfig.getConfig();
                        if (DEBUG) {
                            System.out.println("Loaded from SCDynamicStoreConfig");
                        }
                        bl = true;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    string2 = this.getNativeFileName();
                    List<String> list = this.loadConfigFile(string2);
                    this.stanzaTable = this.parseStanzaTable(list);
                    if (DEBUG) {
                        System.out.println("Loaded from native config");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String get(String ... stringArray) {
        Vector<String> vector = this.getString0(stringArray);
        if (vector == null) {
            return null;
        }
        return vector.lastElement();
    }

    public Boolean getBooleanObject(String ... stringArray) {
        String string = this.get(stringArray);
        if (string == null) {
            return null;
        }
        switch (string.toLowerCase(Locale.US)) {
            case "yes": 
            case "true": {
                return Boolean.TRUE;
            }
            case "no": 
            case "false": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public String getAll(String ... stringArray) {
        Vector<String> vector = this.getString0(stringArray);
        if (vector == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : vector) {
            if (bl) {
                stringBuilder.append(string);
                bl = false;
                continue;
            }
            stringBuilder.append(' ').append(string);
        }
        return stringBuilder.toString();
    }

    public boolean exists(String ... stringArray) {
        return this.get0(stringArray) != null;
    }

    private Vector<String> getString0(String ... stringArray) {
        try {
            return (Vector)this.get0(stringArray);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    private Object get0(String ... stringArray) {
        Object object = this.stanzaTable;
        try {
            for (String string : stringArray) {
                if ((object = ((Hashtable)object).get(string)) != null) continue;
                return null;
            }
            return object;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    public int getIntValue(String ... stringArray) {
        String string = this.get(stringArray);
        int n = Integer.MIN_VALUE;
        if (string != null) {
            try {
                n = this.parseIntValue(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (DEBUG) {
                    System.out.println("Exception in getting value of " + Arrays.toString(stringArray) + " " + numberFormatException.getMessage());
                    System.out.println("Setting " + Arrays.toString(stringArray) + " to minimum value");
                }
                n = Integer.MIN_VALUE;
            }
        }
        return n;
    }

    public boolean getBooleanValue(String ... stringArray) {
        String string = this.get(stringArray);
        return string != null && string.equalsIgnoreCase("true");
    }

    private int parseIntValue(String string) throws NumberFormatException {
        int n = 0;
        if (string.startsWith("+")) {
            String string2 = string.substring(1);
            return Integer.parseInt(string2);
        }
        if (string.startsWith("0x")) {
            String string3 = string.substring(2);
            char[] cArray = string3.toCharArray();
            if (cArray.length > 8) {
                throw new NumberFormatException();
            }
            block18: for (int i = 0; i < cArray.length; ++i) {
                int n2 = cArray.length - i - 1;
                switch (cArray[i]) {
                    case '0': {
                        n += 0;
                        continue block18;
                    }
                    case '1': {
                        n += 1 * this.getBase(n2);
                        continue block18;
                    }
                    case '2': {
                        n += 2 * this.getBase(n2);
                        continue block18;
                    }
                    case '3': {
                        n += 3 * this.getBase(n2);
                        continue block18;
                    }
                    case '4': {
                        n += 4 * this.getBase(n2);
                        continue block18;
                    }
                    case '5': {
                        n += 5 * this.getBase(n2);
                        continue block18;
                    }
                    case '6': {
                        n += 6 * this.getBase(n2);
                        continue block18;
                    }
                    case '7': {
                        n += 7 * this.getBase(n2);
                        continue block18;
                    }
                    case '8': {
                        n += 8 * this.getBase(n2);
                        continue block18;
                    }
                    case '9': {
                        n += 9 * this.getBase(n2);
                        continue block18;
                    }
                    case 'A': 
                    case 'a': {
                        n += 10 * this.getBase(n2);
                        continue block18;
                    }
                    case 'B': 
                    case 'b': {
                        n += 11 * this.getBase(n2);
                        continue block18;
                    }
                    case 'C': 
                    case 'c': {
                        n += 12 * this.getBase(n2);
                        continue block18;
                    }
                    case 'D': 
                    case 'd': {
                        n += 13 * this.getBase(n2);
                        continue block18;
                    }
                    case 'E': 
                    case 'e': {
                        n += 14 * this.getBase(n2);
                        continue block18;
                    }
                    case 'F': 
                    case 'f': {
                        n += 15 * this.getBase(n2);
                        continue block18;
                    }
                    default: {
                        throw new NumberFormatException("Invalid numerical format");
                    }
                }
            }
            if (n < 0) {
                throw new NumberFormatException("Data overflow.");
            }
        } else {
            n = Integer.parseInt(string);
        }
        return n;
    }

    private int getBase(int n) {
        int n2 = 16;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 16;
                break;
            }
            case 2: {
                n2 = 256;
                break;
            }
            case 3: {
                n2 = 4096;
                break;
            }
            default: {
                for (int i = 1; i < n; ++i) {
                    n2 *= 16;
                }
            }
        }
        return n2;
    }

    private List<String> loadConfigFile(final String string) throws IOException, KrbException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws IOException {
                    return new FileInputStream(string);
                }
            })));){
                String string2;
                String string3 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).isEmpty() || string2.startsWith("#") || string2.startsWith(";")) continue;
                    if (string2.startsWith("[")) {
                        String string4;
                        if (!string2.endsWith("]")) {
                            throw new KrbException("Illegal config content:" + string2);
                        }
                        if (string3 != null) {
                            arrayList.add(string3);
                            arrayList.add("}");
                        }
                        if ((string4 = string2.substring(1, string2.length() - 1).trim()).isEmpty()) {
                            throw new KrbException("Illegal config content:" + string2);
                        }
                        string3 = string4 + " = {";
                        continue;
                    }
                    if (string2.startsWith("{")) {
                        if (string3 == null) {
                            throw new KrbException("Config file should not start with \"{\"");
                        }
                        string3 = string3 + " {";
                        if (string2.length() <= 1) continue;
                        arrayList.add(string3);
                        string3 = string2.substring(1).trim();
                        continue;
                    }
                    if (string3 == null) continue;
                    arrayList.add(string3);
                    string3 = string2;
                }
                if (string3 != null) {
                    arrayList.add(string3);
                    arrayList.add("}");
                }
            }
            return arrayList;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private Hashtable<String, Object> parseStanzaTable(List<String> list) throws KrbException {
        Hashtable<String, Cloneable> hashtable = this.stanzaTable;
        for (String string : list) {
            Hashtable<String, Cloneable> hashtable2;
            if (string.equals("}")) {
                if ((hashtable = (Hashtable<String, Cloneable>)hashtable.remove(" PARENT ")) != null) continue;
                throw new KrbException("Unmatched close brace");
            }
            int n = string.indexOf(61);
            if (n < 0) {
                throw new KrbException("Illegal config content:" + string);
            }
            String string2 = string.substring(0, n).trim();
            String string3 = Config.trimmed(string.substring(n + 1));
            if (string3.equals("{")) {
                if (hashtable == this.stanzaTable) {
                    string2 = string2.toLowerCase(Locale.US);
                }
                hashtable2 = new Hashtable();
                hashtable.put(string2, hashtable2);
                hashtable2.put(" PARENT ", hashtable);
                hashtable = hashtable2;
                continue;
            }
            if (hashtable.containsKey(string2)) {
                Object v = hashtable.get(string2);
                if (!(v instanceof Vector)) {
                    throw new KrbException("Key " + string2 + "used for both value and section");
                }
                hashtable2 = (Vector)hashtable.get(string2);
            } else {
                hashtable2 = new Vector();
                hashtable.put(string2, hashtable2);
            }
            ((Vector)((Object)hashtable2)).add(string3);
        }
        if (hashtable != this.stanzaTable) {
            throw new KrbException("Not closed");
        }
        return hashtable;
    }

    private String getJavaFileName() {
        String string = Config.getProperty("java.security.krb5.conf");
        if (string == null && !this.fileExists(string = Config.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "krb5.conf")) {
            string = null;
        }
        if (DEBUG) {
            System.out.println("Java config name: " + string);
        }
        return string;
    }

    private String getNativeFileName() {
        String string = null;
        String string2 = Config.getProperty("os.name");
        if (string2.startsWith("Windows")) {
            try {
                Credentials.ensureLoaded();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Credentials.alreadyLoaded) {
                String string3 = Config.getWindowsDirectory(false);
                if (string3 != null && this.fileExists(string3 = string3.endsWith("\\") ? string3 + "krb5.ini" : string3 + "\\krb5.ini")) {
                    string = string3;
                }
                if (string == null && (string3 = Config.getWindowsDirectory(true)) != null) {
                    string3 = string3.endsWith("\\") ? string3 + "krb5.ini" : string3 + "\\krb5.ini";
                    string = string3;
                }
            }
            if (string == null) {
                string = "c:\\winnt\\krb5.ini";
            }
        } else {
            string = string2.startsWith("SunOS") ? "/etc/krb5/krb5.conf" : (string2.contains("OS X") ? this.findMacosConfigFile() : "/etc/krb5.conf");
        }
        if (DEBUG) {
            System.out.println("Native config name: " + string);
        }
        return string;
    }

    private static String getProperty(String string) {
        return AccessController.doPrivileged(new GetPropertyAction(string));
    }

    private String findMacosConfigFile() {
        String string = Config.getProperty("user.home");
        String string2 = string + "/Library/Preferences/edu.mit.Kerberos";
        if (this.fileExists(string2)) {
            return string2;
        }
        if (this.fileExists("/Library/Preferences/edu.mit.Kerberos")) {
            return "/Library/Preferences/edu.mit.Kerberos";
        }
        return "/etc/krb5.conf";
    }

    private static String trimmed(String string) {
        if ((string = string.trim()).length() >= 2 && (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' || string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'')) {
            string = string.substring(1, string.length() - 1).trim();
        }
        return string;
    }

    public void listTable() {
        System.out.println(this);
    }

    public int[] defaultEtype(String string) throws KrbException {
        int[] nArray;
        String string2 = this.get("libdefaults", string);
        if (string2 == null) {
            if (DEBUG) {
                System.out.println("Using builtin default etypes for " + string);
            }
            nArray = EType.getBuiltInDefaults();
        } else {
            int n;
            int n2;
            String string3 = " ";
            for (n2 = 0; n2 < string2.length(); ++n2) {
                if (!string2.substring(n2, n2 + 1).equals(",")) continue;
                string3 = ",";
                break;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            n2 = stringTokenizer.countTokens();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
            for (n = 0; n < n2; ++n) {
                int n3 = Config.getType(stringTokenizer.nextToken());
                if (n3 == -1 || !EType.isSupported(n3)) continue;
                arrayList.add(n3);
            }
            if (arrayList.isEmpty()) {
                throw new KrbException("no supported default etypes for " + string);
            }
            nArray = new int[arrayList.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
        }
        if (DEBUG) {
            System.out.print("default etypes for " + string + ":");
            for (int i = 0; i < nArray.length; ++i) {
                System.out.print(" " + nArray[i]);
            }
            System.out.println(".");
        }
        return nArray;
    }

    public static int getType(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        if (string.startsWith("d") || string.startsWith("D")) {
            if (string.equalsIgnoreCase("des-cbc-crc")) {
                n = 1;
            } else if (string.equalsIgnoreCase("des-cbc-md5")) {
                n = 3;
            } else if (string.equalsIgnoreCase("des-mac")) {
                n = 4;
            } else if (string.equalsIgnoreCase("des-mac-k")) {
                n = 5;
            } else if (string.equalsIgnoreCase("des-cbc-md4")) {
                n = 2;
            } else if (string.equalsIgnoreCase("des3-cbc-sha1") || string.equalsIgnoreCase("des3-hmac-sha1") || string.equalsIgnoreCase("des3-cbc-sha1-kd") || string.equalsIgnoreCase("des3-cbc-hmac-sha1-kd")) {
                n = 16;
            }
        } else if (string.startsWith("a") || string.startsWith("A")) {
            if (string.equalsIgnoreCase("aes128-cts") || string.equalsIgnoreCase("aes128-cts-hmac-sha1-96")) {
                n = 17;
            } else if (string.equalsIgnoreCase("aes256-cts") || string.equalsIgnoreCase("aes256-cts-hmac-sha1-96")) {
                n = 18;
            } else if (string.equalsIgnoreCase("arcfour-hmac") || string.equalsIgnoreCase("arcfour-hmac-md5")) {
                n = 23;
            }
        } else if (string.equalsIgnoreCase("rc4-hmac")) {
            n = 23;
        } else if (string.equalsIgnoreCase("CRC32")) {
            n = 1;
        } else if (string.startsWith("r") || string.startsWith("R")) {
            if (string.equalsIgnoreCase("rsa-md5")) {
                n = 7;
            } else if (string.equalsIgnoreCase("rsa-md5-des")) {
                n = 8;
            }
        } else if (string.equalsIgnoreCase("hmac-sha1-des3-kd")) {
            n = 12;
        } else if (string.equalsIgnoreCase("hmac-sha1-96-aes128")) {
            n = 15;
        } else if (string.equalsIgnoreCase("hmac-sha1-96-aes256")) {
            n = 16;
        } else if (string.equalsIgnoreCase("hmac-md5-rc4") || string.equalsIgnoreCase("hmac-md5-arcfour") || string.equalsIgnoreCase("hmac-md5-enc")) {
            n = -138;
        } else if (string.equalsIgnoreCase("NULL")) {
            n = 0;
        }
        return n;
    }

    public void resetDefaultRealm(String string) {
        if (DEBUG) {
            System.out.println(">>> Config try resetting default kdc " + string);
        }
    }

    public boolean useAddresses() {
        boolean bl = false;
        String string = this.get("libdefaults", "no_addresses");
        boolean bl2 = bl = string != null && string.equalsIgnoreCase("false");
        if (!bl) {
            string = this.get("libdefaults", "noaddresses");
            bl = string != null && string.equalsIgnoreCase("false");
        }
        return bl;
    }

    private boolean useDNS(String string, boolean bl) {
        Boolean bl2 = this.getBooleanObject("libdefaults", string);
        if (bl2 != null) {
            return bl2;
        }
        bl2 = this.getBooleanObject("libdefaults", "dns_fallback");
        if (bl2 != null) {
            return bl2;
        }
        return bl;
    }

    private boolean useDNS_KDC() {
        return this.useDNS("dns_lookup_kdc", true);
    }

    private boolean useDNS_Realm() {
        return this.useDNS("dns_lookup_realm", false);
    }

    public String getDefaultRealm() throws KrbException {
        if (this.defaultRealm != null) {
            return this.defaultRealm;
        }
        KrbException krbException = null;
        String string = this.get("libdefaults", "default_realm");
        if (string == null && this.useDNS_Realm()) {
            try {
                string = this.getRealmFromDNS();
            }
            catch (KrbException krbException2) {
                krbException = krbException2;
            }
        }
        if (string == null) {
            string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String string = System.getProperty("os.name");
                    if (string.startsWith("Windows")) {
                        return System.getenv("USERDNSDOMAIN");
                    }
                    return null;
                }
            });
        }
        if (string == null) {
            KrbException krbException3 = new KrbException("Cannot locate default realm");
            if (krbException != null) {
                krbException3.initCause(krbException);
            }
            throw krbException3;
        }
        return string;
    }

    public String getKDCList(String string) throws KrbException {
        if (string == null) {
            string = this.getDefaultRealm();
        }
        if (string.equalsIgnoreCase(this.defaultRealm)) {
            return this.defaultKDC;
        }
        KrbException krbException = null;
        String string2 = this.getAll("realms", string, "kdc");
        if (string2 == null && this.useDNS_KDC()) {
            try {
                string2 = this.getKDCFromDNS(string);
            }
            catch (KrbException krbException2) {
                krbException = krbException2;
            }
        }
        if (string2 == null) {
            string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String string = System.getProperty("os.name");
                    if (string.startsWith("Windows")) {
                        String string2 = System.getenv("LOGONSERVER");
                        if (string2 != null && string2.startsWith("\\\\")) {
                            string2 = string2.substring(2);
                        }
                        return string2;
                    }
                    return null;
                }
            });
        }
        if (string2 == null) {
            if (this.defaultKDC != null) {
                return this.defaultKDC;
            }
            KrbException krbException3 = new KrbException("Cannot locate KDC");
            if (krbException != null) {
                krbException3.initCause(krbException);
            }
            throw krbException3;
        }
        return string2;
    }

    private String getRealmFromDNS() throws KrbException {
        String string = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            KrbException krbException = new KrbException(60, "Unable to locate Kerberos realm: " + unknownHostException.getMessage());
            krbException.initCause(unknownHostException);
            throw krbException;
        }
        String string3 = PrincipalName.mapHostToRealm(string2);
        if (string3 == null) {
            String string4;
            List<String> list = ResolverConfiguration.open().searchlist();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext() && (string = Config.checkRealm(string4 = iterator.next())) == null) {
            }
        } else {
            string = Config.checkRealm(string3);
        }
        if (string == null) {
            throw new KrbException(60, "Unable to locate Kerberos realm");
        }
        return string;
    }

    private static String checkRealm(String string) {
        if (DEBUG) {
            System.out.println("getRealmFromDNS: trying " + string);
        }
        String[] stringArray = null;
        String string2 = string;
        while (stringArray == null && string2 != null) {
            stringArray = KrbServiceLocator.getKerberosService(string2);
            string2 = Realm.parseRealmComponent(string2);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                return stringArray[i];
            }
        }
        return null;
    }

    private String getKDCFromDNS(String string) throws KrbException {
        String string2 = "";
        String[] stringArray = null;
        if (DEBUG) {
            System.out.println("getKDCFromDNS using UDP");
        }
        if ((stringArray = KrbServiceLocator.getKerberosService(string, "_udp")) == null) {
            if (DEBUG) {
                System.out.println("getKDCFromDNS using TCP");
            }
            stringArray = KrbServiceLocator.getKerberosService(string, "_tcp");
        }
        if (stringArray == null) {
            throw new KrbException(60, "Unable to locate KDC for realm " + string);
        }
        if (stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i].trim() + " ";
        }
        if ((string2 = string2.trim()).equals("")) {
            return null;
        }
        return string2;
    }

    private boolean fileExists(String string) {
        return AccessController.doPrivileged(new FileExistsAction(string));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Config.toStringInternal("", this.stanzaTable, stringBuffer);
        return stringBuffer.toString();
    }

    private static void toStringInternal(String string, Object object, StringBuffer stringBuffer) {
        if (object instanceof String) {
            stringBuffer.append(object).append('\n');
        } else if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            stringBuffer.append("{\n");
            for (Object k : hashtable.keySet()) {
                stringBuffer.append(string).append("    ").append(k).append(" = ");
                Config.toStringInternal(string + "    ", hashtable.get(k), stringBuffer);
            }
            stringBuffer.append(string).append("}\n");
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            stringBuffer.append("[");
            boolean bl = true;
            for (Object object2 : vector.toArray()) {
                if (!bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(object2);
                bl = false;
            }
            stringBuffer.append("]\n");
        }
    }

    static {
        String string = SecurityProperties.privilegedGetOverridable("sun.security.krb5.disableReferrals");
        DISABLE_REFERRALS = string != null ? "true".equalsIgnoreCase(string) : false;
        int n = 5;
        String string2 = SecurityProperties.privilegedGetOverridable("sun.security.krb5.maxReferrals");
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        MAX_REFERRALS = n;
        singleton = null;
        DEBUG = Krb5.DEBUG;
    }

    static class FileExistsAction
    implements PrivilegedAction<Boolean> {
        private String fileName;

        public FileExistsAction(String string) {
            this.fileName = string;
        }

        @Override
        public Boolean run() {
            return new File(this.fileName).exists();
        }
    }
}

